/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.SkipCacheCheck;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CheckCachesRule
implements TestRule {
    private final Supplier<Backdoor> backdoorSupplier;

    public CheckCachesRule(Supplier<Backdoor> backdoorSupplier) {
        this.backdoorSupplier = backdoorSupplier;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                base.evaluate();
                boolean skip = false;
                if (description.getAnnotation(SkipCacheCheck.class) != null) {
                    skip = true;
                } else if (description.isTest() && description.getTestClass() != null && description.getTestClass().isAnnotationPresent(SkipCacheCheck.class)) {
                    skip = true;
                }
                if (!skip) {
                    CheckCachesRule.this.checkCaches();
                }
            }
        };
    }

    private void checkCaches() {
        this.backdoorSupplier.get().cacheCheckControl().checkSerialization();
    }
}

