/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.rule.StatementDecorator;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DisableOnboardingRule
implements TestRule {
    public static final String DARK_FEATURE_DISABLE_LANDING_PAGE_REDIRECT_FLAG = "jira.onboarding.feature.disabled";
    private final Supplier<Backdoor> backdoorSupplier;

    public DisableOnboardingRule(Supplier<Backdoor> backdoorSupplier) {
        this.backdoorSupplier = backdoorSupplier;
    }

    public Statement apply(Statement base, Description description) {
        return new StatementDecorator(base, this::disableOnboarding);
    }

    private void disableOnboarding() {
        if (this.getBackdoor().dataImport().isSetUp()) {
            this.getBackdoor().darkFeatures().enableForSite(DARK_FEATURE_DISABLE_LANDING_PAGE_REDIRECT_FLAG);
        }
    }

    private Backdoor getBackdoor() {
        return this.backdoorSupplier.get();
    }
}

