/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.util.junit.AnnotatedDescription;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EnableAnalyticsRule
implements TestRule {
    private Backdoor backdoor;
    private boolean shouldDisableAfter = false;

    public EnableAnalyticsRule(Supplier<Backdoor> backdoorSupplier) {
        this.backdoor = backdoorSupplier.get();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                EnableAnalyticsRule.this.starting(description);
                base.evaluate();
                EnableAnalyticsRule.this.finished();
            }
        };
    }

    protected void starting(@Nonnull Description description) {
        AnnotatedDescription annotatedDescription = new AnnotatedDescription(description);
        if (!annotatedDescription.isMethodAnnotated(EnableAnalytics.class)) {
            return;
        }
        this.shouldDisableAfter = !this.backdoor.analyticsEventsControl().isEnabled();
        this.backdoor.analyticsEventsControl().enable().clear();
    }

    protected void finished() {
        if (this.shouldDisableAfter) {
            this.backdoor.analyticsEventsControl().disable();
        }
    }
}

