/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.SkipSetup;
import com.atlassian.jira.functest.framework.TestAnnotationsExtractor;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.functest.rule.StatementDecorator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.function.Supplier;
import net.sourceforge.jwebunit.WebTester;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class EnsureJiraSetupRule
implements TestRule {
    private final Supplier<Backdoor> backdoorSupplier;
    private final Supplier<JIRAEnvironmentData> environmentDataSupplier;
    private final Supplier<WebTester> webTesterSupplier;

    public EnsureJiraSetupRule(Supplier<Backdoor> backdoorSupplier, Supplier<JIRAEnvironmentData> environmentDataSupplier, Supplier<WebTester> webTesterSupplier) {
        this.backdoorSupplier = backdoorSupplier;
        this.environmentDataSupplier = environmentDataSupplier;
        this.webTesterSupplier = webTesterSupplier;
    }

    public Statement apply(Statement base, Description description) {
        return this.isSkipSetupAnnotationPresent(description) ? base : new StatementDecorator(base, this::ensureJiraIsSetup);
    }

    private boolean isSkipSetupAnnotationPresent(Description description) {
        return new TestAnnotationsExtractor(description).findAnnotationFor(SkipSetup.class).isPresent();
    }

    public void ensureJiraIsSetup() {
        Backdoor backdoor = this.backdoorSupplier.get();
        boolean jiraIsSetup = backdoor.dataImport().isSetUp();
        if (!jiraIsSetup) {
            new JiraSetupInstanceHelper(this.webTesterSupplier.get(), this.environmentDataSupplier.get()).ensureJIRAIsReadyToGo();
        }
    }
}

