/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.log.LogOnBothSides;
import com.atlassian.jira.testkit.client.Backdoor;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LogTimeRule
implements TestRule {
    private final Supplier<JIRAEnvironmentData> environmentDataSupplier;
    private final Supplier<FuncTestWebClientListener> webClientListenerSupplier;
    private final Collection<Supplier<Backdoor>> testkitSuppliers;

    public LogTimeRule(Supplier<JIRAEnvironmentData> environmentDataSupplier, Supplier<FuncTestWebClientListener> webClientListenerSupplier, Supplier<Backdoor> testkitSuppliers) {
        this.environmentDataSupplier = environmentDataSupplier;
        this.webClientListenerSupplier = webClientListenerSupplier;
        this.testkitSuppliers = ImmutableSet.of(testkitSuppliers);
    }

    @Inject
    public LogTimeRule(JIRAEnvironmentData environmentDataSupplier, Backdoor testkitSupplier) {
        this(() -> environmentDataSupplier, (Collection<Supplier<Backdoor>>)ImmutableSet.of(() -> testkitSupplier));
    }

    public LogTimeRule(Supplier<JIRAEnvironmentData> environmentDataSupplier, Collection<Supplier<Backdoor>> testkitSuppliers) {
        this.environmentDataSupplier = environmentDataSupplier;
        this.webClientListenerSupplier = () -> null;
        this.testkitSuppliers = ImmutableSet.copyOf(testkitSuppliers);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                long startTime = System.currentTimeMillis();
                JIRAEnvironmentData data = (JIRAEnvironmentData)LogTimeRule.this.environmentDataSupplier.get();
                Collection testkits = LogTimeRule.this.testkitSuppliers.stream().map(Supplier::get).collect(Collectors.toSet());
                LogOnBothSides.log(testkits, TestInformationKit.getStartMsg(description, data.getTenant()));
                FuncTestWebClientListener webClientListener = (FuncTestWebClientListener)LogTimeRule.this.webClientListenerSupplier.get();
                try {
                    base.evaluate();
                    LogOnBothSides.log(testkits, TestInformationKit.getEndMsg(description, data.getTenant(), System.currentTimeMillis() - startTime, webClientListener));
                }
                catch (Throwable throwable) {
                    LogOnBothSides.log(testkits, TestInformationKit.getEndMsg(description, data.getTenant(), System.currentTimeMillis() - startTime, webClientListener, throwable));
                    throw throwable;
                }
            }
        };
    }
}

