/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RestoreDataOnlyOnce
implements TestRule {
    private final Supplier<Backdoor> backdoorSupplier;

    public RestoreDataOnlyOnce(Supplier<Backdoor> backdoorSupplier) {
        this.backdoorSupplier = backdoorSupplier;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RestoreDataOnlyOnce.this.tryInitializeData(description);
                base.evaluate();
            }
        };
    }

    private void tryInitializeData(Description description) {
        Class testClass = description.getTestClass();
        RestoreOnce restoreOnce = testClass.getAnnotation(RestoreOnce.class);
        if (restoreOnce != null) {
            this.backdoorSupplier.get().restoreDataFromResource(restoreOnce.value());
        }
    }
}

