/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TpmDbRule
implements TestRule {
    private final Supplier<EnvironmentUtils> environmentUtilsSupplier;

    public TpmDbRule(Supplier<EnvironmentUtils> environmentUtilsSupplier) {
        this.environmentUtilsSupplier = environmentUtilsSupplier;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TpmSpecificDb tpmSpecificDb = (TpmSpecificDb)description.getAnnotation(TpmSpecificDb.class);
                boolean skip = false;
                if (tpmSpecificDb != null && tpmSpecificDb.databases() != null && tpmSpecificDb.databases().length > 0) {
                    EnvironmentUtils environmentUtils = (EnvironmentUtils)TpmDbRule.this.environmentUtilsSupplier.get();
                    skip = Arrays.stream(tpmSpecificDb.databases()).noneMatch(tpmDbType -> tpmDbType.isType(environmentUtils));
                }
                if (!skip) {
                    base.evaluate();
                } else {
                    Assume.assumeTrue((String)String.format("%s has been skipped because unsupported DB (annotations: %s)", description.getDisplayName(), Arrays.toString((Object[])tpmSpecificDb.databases())), (boolean)false);
                }
            }
        };
    }

    public static enum TpmDbType {
        H2(EnvironmentUtils::isH2),
        MYSQL(EnvironmentUtils::isMySQL),
        POSTGRES(EnvironmentUtils::isPostgres),
        MSSQL(EnvironmentUtils::isMSSQL),
        ORACLE(EnvironmentUtils::isOracle);

        private final Predicate<EnvironmentUtils> isDbType;

        private TpmDbType(Predicate<EnvironmentUtils> isDbType) {
            this.isDbType = isDbType;
        }

        boolean isType(EnvironmentUtils environmentUtils) {
            return this.isDbType.test(environmentUtils);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TpmSpecificDb {
        public TpmDbType[] databases();
    }
}

