/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.rule;

import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Session;
import com.atlassian.jira.functest.framework.SessionFactory;
import com.atlassian.jira.functest.framework.dump.DumpDataProvider;
import com.atlassian.jira.functest.framework.dump.TestCaseDumpKit;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.meterware.httpunit.WebClientListener;
import java.util.Date;
import java.util.function.Supplier;
import javax.ws.rs.ClientErrorException;
import net.sourceforge.jwebunit.WebTester;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class WebTesterRule
implements TestRule,
Module,
Supplier<WebTester> {
    private final Supplier<JIRAEnvironmentData> environmentDataSupplier;
    private final Supplier<FuncTestWebClientListener> webClientListenerSupplier;
    private final SessionFactory sessionFactory = () -> new SessionImpl(this.createAndInitWebTester());
    private SessionImpl currentSession = null;
    protected LocatorFactory locator;
    private final WebTester testerProxy = (WebTester)Enhancer.create(WebTester.class, (Callback)((MethodInterceptor)(obj, method, args, proxy) -> proxy.invoke((Object)this.currentSession.tester, args)));

    public WebTesterRule(Supplier<JIRAEnvironmentData> environmentDataSupplier, Supplier<FuncTestWebClientListener> webClientListenerSupplier) {
        this.environmentDataSupplier = environmentDataSupplier;
        this.webClientListenerSupplier = webClientListenerSupplier;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WebTesterRule.this.evaluateLogException(base, description);
            }
        };
    }

    @Override
    public WebTester get() {
        if (this.currentSession == null) {
            this.currentSession = (SessionImpl)this.sessionFactory.begin();
        }
        return this.testerProxy;
    }

    private WebTester createAndInitWebTester() {
        FuncTestWebClientListener webClientListener = this.webClientListenerSupplier.get();
        WebTester tester = WebTesterFactory.createNewWebTester(this.environmentDataSupplier.get());
        tester.beginAt("/");
        if (webClientListener != null) {
            tester.getDialog().getWebClient().addClientListener((WebClientListener)webClientListener);
        }
        return tester;
    }

    public void configure(Binder binder) {
        binder.bind(WebTester.class).toProvider(this::get);
        binder.bind(SessionFactory.class).toInstance((Object)this.sessionFactory);
    }

    private void evaluateLogException(Statement base, Description description) throws Throwable {
        try {
            base.evaluate();
        }
        catch (Throwable th) {
            if (th instanceof ClientErrorException) {
                TestCaseDumpKit.dumpRestTestInformation((ClientErrorException)th, description);
            } else {
                this.dumpFailureInformationIfTesterExists(th, description);
            }
            throw th;
        }
    }

    private void dumpFailureInformationIfTesterExists(Throwable throwable, Description description) {
        if (this.currentSession != null) {
            this.dumpFailureInformation(this.currentSession.tester, throwable, description);
        }
    }

    private void dumpFailureInformation(WebTester tester, Throwable throwable, Description description) {
        try {
            TestCaseDumpKit.dumpTestInformation(this.getDataProvider(description.getDisplayName(), tester), new Date(), throwable, true);
        }
        catch (RuntimeException ignored) {
            ignored.printStackTrace();
        }
    }

    private DumpDataProvider getDataProvider(final String testName, final WebTester tester) {
        return new DumpDataProvider(){

            @Override
            public JIRAEnvironmentData getEnvironmentData() {
                return (JIRAEnvironmentData)WebTesterRule.this.environmentDataSupplier.get();
            }

            @Override
            public FuncTestWebClientListener getFuncTestWebClientListener() {
                return (FuncTestWebClientListener)WebTesterRule.this.webClientListenerSupplier.get();
            }

            @Override
            public String getTestName() {
                return testName;
            }

            @Override
            public WebTester getWebTester() {
                return tester;
            }
        };
    }

    private class SessionImpl
    implements Session {
        private final WebTester tester;

        public SessionImpl(WebTester tester) {
            this.tester = tester;
        }

        @Override
        public void withSession(Runnable runnable) {
            SessionImpl previousSession = WebTesterRule.this.currentSession;
            WebTesterRule.this.currentSession = this;
            try {
                runnable.run();
            }
            finally {
                WebTesterRule.this.currentSession = previousSession;
            }
        }
    }
}

