/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.hallelujah;

import com.atlassian.buildeng.hallelujah.api.model.TestCaseFailure;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;
import com.atlassian.buildeng.hallelujah.api.server.AbstractServerListener;
import com.atlassian.buildeng.hallelujah.api.server.ServerTestCaseProvider;
import com.atlassian.buildeng.hallelujah.api.server.ServerTestCaseResultCollector;
import com.atlassian.jira.hallelujah.SlowTestUtils;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class FailSlowTestsListener
extends AbstractServerListener {
    private static final long SECOND_IN_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long MAX_EXPECTED_JIRA_SETUP = TimeUnit.MINUTES.toMillis(5L);
    private static final String TIMEOUT_MESSAGE = "timeout";
    private final long maxAllowedDurationMS;
    private final long slowTestsMaxAllowedDurationMS;
    private final ConcurrentMap<String, Boolean> visitedRunners = Maps.newConcurrentMap();
    private final String failMessage;
    private final String slowTestFailMessage;
    private final SlowTestUtils slowTestUtils;

    public FailSlowTestsListener(long maxAllowedDuration, long slowTestsMaxAllowedDuration, TimeUnit unit, SlowTestUtils slowTestUtils) {
        this.slowTestUtils = slowTestUtils;
        this.maxAllowedDurationMS = unit.toMillis(maxAllowedDuration);
        this.slowTestsMaxAllowedDurationMS = unit.toMillis(slowTestsMaxAllowedDuration);
        this.failMessage = "Test failed because its execution exceeded " + this.maxAllowedDurationMS + " ms";
        this.slowTestFailMessage = "Test failed because its execution exceeded " + this.slowTestsMaxAllowedDurationMS + " ms (this test was marked as slow test)";
    }

    public boolean onResultReceived(ServerTestCaseResultCollector serverTestCaseResultCollector, ServerTestCaseProvider serverTestCaseProvider, TestCaseResult testCaseResult) {
        long slowTestsMaxTime;
        long maxTime;
        if (this.visitedRunners.putIfAbsent(testCaseResult.runnerId, Boolean.TRUE) == null) {
            maxTime = this.maxAllowedDurationMS + MAX_EXPECTED_JIRA_SETUP;
            slowTestsMaxTime = this.slowTestsMaxAllowedDurationMS + MAX_EXPECTED_JIRA_SETUP;
        } else {
            maxTime = this.maxAllowedDurationMS;
            slowTestsMaxTime = this.slowTestsMaxAllowedDurationMS;
        }
        if (testCaseResult.passed) {
            if (this.slowTestUtils.isTestSlow(testCaseResult.testCaseName)) {
                if (this.timeExceeded(slowTestsMaxTime, testCaseResult)) {
                    testCaseResult.passed = false;
                    testCaseResult.failure = this.getTestCaseFailure(this.slowTestFailMessage);
                }
            } else if (this.timeExceeded(maxTime, testCaseResult)) {
                testCaseResult.passed = false;
                testCaseResult.failure = this.getTestCaseFailure(this.failMessage);
            }
        }
        return true;
    }

    private TestCaseFailure getTestCaseFailure(String message) {
        TestCaseFailure failure = new TestCaseFailure();
        failure.message = message;
        failure.type = TIMEOUT_MESSAGE;
        failure.log = "";
        return failure;
    }

    private boolean timeExceeded(long maxTime, TestCaseResult testCaseResult) {
        return testCaseResult.duration * (double)SECOND_IN_MS > (double)maxTime;
    }
}

