/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.hallelujah;

import com.atlassian.buildeng.hallelujah.api.model.TestCaseName;
import com.atlassian.jira.util.SlowTest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SlowTestUtils {
    SlowTestUtils() {
    }

    List<TestCaseName> sortWithSlowTestClassesFirst(List<TestCaseName> testCaseNames) {
        return testCaseNames.stream().map(this::createSlowTestCase).sorted().map(t -> t.testCaseName).collect(Collectors.toList());
    }

    boolean isTestSlow(TestCaseName testCaseName) {
        Class aClass = this.getClassFromTestCaseName(testCaseName);
        Method method1 = Stream.iterate(aClass, c -> c.getSuperclass()).flatMap(c -> Stream.of(c.getDeclaredMethods())).filter(method -> method.getName().equals(testCaseName.methodName)).findFirst().get();
        return method1.getAnnotation(SlowTest.class) != null;
    }

    private SlowTestCase createSlowTestCase(TestCaseName testCaseName) {
        return new SlowTestCase(testCaseName, this.isTestClassSlow(testCaseName));
    }

    private boolean isTestClassSlow(TestCaseName testCaseName) {
        Class aClass = this.getClassFromTestCaseName(testCaseName);
        return this.getSuperClasses(aClass).stream().flatMap(c -> Stream.of(c.getDeclaredMethods())).anyMatch(method -> method.getAnnotation(SlowTest.class) != null);
    }

    private Class getClassFromTestCaseName(TestCaseName testCaseName) {
        Class<?> aClass;
        try {
            aClass = Class.forName(testCaseName.className, false, SlowTestUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return aClass;
    }

    private List<Class<?>> getSuperClasses(Class aClass) {
        ArrayList result = new ArrayList();
        for (Class clazz = aClass; clazz != null; clazz = clazz.getSuperclass()) {
            result.add(clazz);
        }
        return result;
    }

    private static final class SlowTestCase
    implements Comparable<SlowTestCase> {
        final TestCaseName testCaseName;
        final boolean isSlow;

        private SlowTestCase(TestCaseName testCaseName, boolean isSlow) {
            this.testCaseName = testCaseName;
            this.isSlow = isSlow;
        }

        @Override
        public int compareTo(SlowTestCase that) {
            if (this.isSlow && !that.isSlow) {
                return -1;
            }
            if (!this.isSlow && that.isSlow) {
                return 1;
            }
            return 0;
        }
    }
}

