/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class GadgetSpecClient
extends RestApiClient<GadgetSpecClient> {
    private final String GADGET_SPEC_BASE_URL = "rest/gadgets/1.0/g/";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String rootPath;

    public GadgetSpecClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.rootPath = environmentData.getBaseUrl().toExternalForm();
    }

    private WebTarget createGadgetFeedResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("gadgets").path("1.0").path("g").path("feed");
    }

    private WebTarget createGadgetSpecResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("gadgets").path("1.0").path("g");
    }

    private WebTarget createAddGadgetDirectoryResource() {
        return this.resourceRoot(this.rootPath).path("rest").path("config").path("1.0").path("directory.json");
    }

    public List<String> getAddableGadgets() {
        ParsedResponse<String> directoryResponse = this.makeRequestAndExpectStringResponse(this.createAddGadgetDirectoryResource());
        JsonNode directoryJson = null;
        try {
            directoryJson = this.objectMapper.readTree((String)directoryResponse.body);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        JsonNode gadgetsListJson = directoryJson.get("gadgets");
        ArrayList gadgetSpecUris = Lists.newArrayList();
        Iterator itr = gadgetsListJson.elements();
        while (itr.hasNext()) {
            JsonNode gadgetJsonNode = (JsonNode)itr.next();
            JsonNode gadgetSpecUriJsonNode = gadgetJsonNode.get("gadgetSpecUri");
            if (gadgetSpecUriJsonNode == null) continue;
            gadgetSpecUris.add(gadgetSpecUriJsonNode.textValue().replace("rest/gadgets/1.0/g/", ""));
        }
        return gadgetSpecUris;
    }

    public String getFeedResourceContent() {
        ParsedResponse<String> feedResponse = this.makeRequestAndExpectStringResponse(this.createGadgetFeedResource());
        return (String)feedResponse.body;
    }

    public ParsedResponse<String> getGadgetSpecXML(String publishLocation) {
        return this.makeRequestAndExpectStringResponse(this.createGadgetSpecResource().path(publishLocation));
    }

    private ParsedResponse<String> makeRequestAndExpectStringResponse(WebTarget webresource) {
        return this.toResponse(() -> (Response)webresource.request().get(Response.class), String.class);
    }
}

