/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BidiUtils {
    public static final FeatureFlag BIDI_ESCAPING = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.RTE_WARN_ABOUT_BIDI_CHARS.featureKey());

    public static String getBidis() {
        return BidiUtils.bidisStream().map(Character::toChars).reduce(new StringBuilder(), StringBuilder::append, StringBuilder::append).toString();
    }

    public static String getCodePanelWithEscapedBidis() {
        return "<div class=\"code panel\" style=\"border-width: 1px;\"><div class=\"codeContent panelContent\">\n<pre class=\"code-java\">" + BidiUtils.getEscapedBidis().collect(Collectors.joining("")) + "</pre>\n</div></div>";
    }

    public static String getCodePanelWithUnescapedBidis() {
        return "<div class=\"code panel\" style=\"border-width: 1px;\"><div class=\"codeContent panelContent\">\n<pre class=\"code-java\">" + BidiUtils.getBidis() + "</pre>\n</div></div>";
    }

    public static String getNoFormatPanelWithEscapedBidis() {
        return "<div class=\"preformatted panel\" style=\"border-width: 1px;\"><div class=\"preformattedContent panelContent\">\n<pre>" + BidiUtils.getEscapedBidis().collect(Collectors.joining("")) + "</pre>\n</div></div>";
    }

    public static String getNoFormatPanelWithUnescapedBidis() {
        return "<div class=\"preformatted panel\" style=\"border-width: 1px;\"><div class=\"preformattedContent panelContent\">\n<pre>" + BidiUtils.getBidis() + "</pre>\n</div></div>";
    }

    public static Stream<String> getEscapedBidis() {
        String format = "<span contenteditable=\"false\" class=\"bidi-unicode\" title=\"%s\" data-bidi-character-code=\"%s\">%s<!--Bidi char--></span>";
        String title = "Bidirectional characters change the order that text is rendered. This could be used to obscure malicious code.";
        return BidiUtils.bidisStream().map(Integer::toHexString).map(String::toUpperCase).map(bidi -> String.format(format, title, bidi, String.valueOf(Character.toChars(Integer.parseInt(bidi, 16)))));
    }

    private static Stream<Integer> bidisStream() {
        return Stream.of(8234, 8235, 8236, 8237, 8238, 8294, 8295, 8296, 8297);
    }
}

