/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.util.AbstractEnvironmentData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTestEnvironmentData
extends AbstractEnvironmentData {
    private static final Logger log = LoggerFactory.getLogger(LocalTestEnvironmentData.class);
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "8080";
    private static final String DEFAULT_CONTEXT = "";
    private static final String DEFAULT_EDITION = "standard";
    private static final String DEFAULT_XML_DATA_LOCATION = "./xml";
    private static final String DEFAULT_PROPERTIES_FILENAME = "localtest.properties";
    private static final String JIRA_PROTOCOL = "jira.protocol";
    private static final String JIRA_HOST = "jira.host";
    private static final String JIRA_PORT = "jira.port";
    private static final String JIRA_XML_DATA_LOCATION = "jira.xml.data.location";
    private static final String JIRA_CONTEXT = "jira.context";
    private static final String JIRA_TENANT = "jira.tenant";
    private static final String CREATE_DUMMY_TENANT = "jira.create.dummy.tenant";
    private static final String TEST_SERVER_PROPERTIES = "test.server.properties";
    public static final LocalTestEnvironmentData DEFAULT = new LocalTestEnvironmentData();
    private final String context;
    private final String tenant;
    private final boolean shouldCreateDummyTenant;
    private final URL url;
    private File xmlDataLocation;
    private final String edition;

    public LocalTestEnvironmentData() {
        this(LocalTestEnvironmentData.loadProperties(TEST_SERVER_PROPERTIES, DEFAULT_PROPERTIES_FILENAME), null);
    }

    public LocalTestEnvironmentData(String xmlDataLocation) {
        this(LocalTestEnvironmentData.loadProperties(TEST_SERVER_PROPERTIES, DEFAULT_PROPERTIES_FILENAME), xmlDataLocation);
    }

    public LocalTestEnvironmentData(Properties properties, @Nullable String xmlDataLocation) {
        super(properties);
        String protocol = this.getEnvironmentProperty(JIRA_PROTOCOL, DEFAULT_PROTOCOL);
        String host = this.getEnvironmentProperty(JIRA_HOST, DEFAULT_HOST);
        String port = this.getEnvironmentProperty(JIRA_PORT, DEFAULT_PORT);
        String propertyString = this.getEnvironmentProperty(JIRA_XML_DATA_LOCATION, DEFAULT_XML_DATA_LOCATION).trim();
        String contextPath = this.getEnvironmentProperty(JIRA_CONTEXT, DEFAULT_CONTEXT, true);
        File unresolvedFileLocation = new File(xmlDataLocation != null ? xmlDataLocation : propertyString);
        try {
            this.xmlDataLocation = unresolvedFileLocation.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException trying to resolve file " + unresolvedFileLocation);
        }
        if (!this.xmlDataLocation.exists()) {
            String firstShotXmlDataLocation = this.xmlDataLocation.getAbsolutePath();
            this.xmlDataLocation = new File(new File(DEFAULT_CONTEXT).getAbsoluteFile().getParentFile(), unresolvedFileLocation.getPath());
            if (!this.xmlDataLocation.exists()) {
                log.warn("Cannot find xml data location: {} or {}", (Object)firstShotXmlDataLocation, (Object)this.xmlDataLocation.getAbsolutePath());
            }
        }
        String baseUrl = protocol + "://" + host + ":" + port + contextPath;
        this.context = contextPath;
        this.tenant = this.getEnvironmentProperty(JIRA_TENANT, null);
        this.shouldCreateDummyTenant = Boolean.parseBoolean(this.getEnvironmentProperty(CREATE_DUMMY_TENANT, "false"));
        try {
            this.url = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL " + baseUrl);
        }
        this.edition = this.getEnvironmentProperty("jira.edition", DEFAULT_EDITION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String key, String def) {
        Properties properties;
        Properties properties2 = new Properties();
        String propertiesFileName = DEFAULT_CONTEXT;
        propertiesFileName = System.getProperty(key, def);
        InputStream propStream = ClassLoaderUtils.getResourceAsStream((String)propertiesFileName, LocalTestEnvironmentData.class);
        if (propStream == null) {
            propStream = new FileInputStream(propertiesFileName);
        }
        try {
            properties2.load(propStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)propStream);
                throw throwable;
            }
            catch (IOException e) {
                FuncTestOut.out.println("Cannot load file " + propertiesFileName + " from CLASSPATH.");
                e.printStackTrace(FuncTestOut.out);
                return properties2;
            }
        }
        IOUtils.closeQuietly((InputStream)propStream);
        return properties;
    }

    @Override
    public String getProperty(String key) {
        return this.getEnvironmentProperty(key, null, true);
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    @Override
    public boolean shouldCreateDummyTenant() {
        return this.shouldCreateDummyTenant;
    }

    @Override
    public URL getBaseUrl() {
        return this.url;
    }

    @Override
    public File getXMLDataLocation() {
        return this.xmlDataLocation;
    }

    @Override
    public File getWorkingDirectory() {
        File file = new File(System.getProperty("java.io.tmpdir"), "jira_autotest");
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not create JIRA home dir " + file);
        }
    }

    @Override
    public File getJIRAHomeLocation() {
        return this.getWorkingDirectory();
    }

    @Override
    public String getEdition() {
        return this.edition;
    }
}

