/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.util.mail;

import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.JIRAGreenMailSetup;
import com.atlassian.jira.webtests.JIRAServerSetup;
import com.icegreen.greenmail.server.AbstractServer;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.util.DummySSLSocketFactory;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.net.BindException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.Supplier;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailService {
    private GreenMail greenMail;
    private HashSet<GreenMailUser> greenMailUsers = new HashSet();
    private Supplier<FuncTestLogger> log;

    public MailService(FuncTestLogger log) {
        this.log = () -> log;
    }

    public MailService(Supplier<FuncTestLogger> log) {
        this.log = log;
    }

    public GreenMail configureAndStartGreenMail(JIRAServerSetup ... serverSetups) throws BindException {
        this.log.get().log((Object)"Configuring and starting JIRA green mail server");
        JIRAGreenMailSetup jiraGreenMailSetup = new JIRAGreenMailSetup(serverSetups);
        for (int setupRetries = 0; setupRetries < 10; ++setupRetries) {
            this.greenMail = this.tryStartingGreenMail(jiraGreenMailSetup.getServerSetups());
            if (this.greenMail != null) {
                this.log.get().log((Object)"Successfully started green mail server");
                return this.greenMail;
            }
            this.log.get().log((Object)("Some servers did not start properly. Incrementing ports and trying again... '" + setupRetries + "'"));
            jiraGreenMailSetup.incrementPorts();
        }
        throw new BindException("Unable to start GreenMail server due to port conflicts.");
    }

    private GreenMail tryStartingGreenMail(ServerSetup[] serverSetups) {
        GreenMail greenMail = new GreenMail(serverSetups);
        try {
            greenMail.start();
        }
        catch (IllegalStateException e) {
            this.log.get().log((Object)("Couldn't start greenmail: " + e.getMessage()));
            greenMail.stop();
            return null;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> servers = new ArrayList<Object>();
        servers.add(greenMail.getSmtp());
        servers.add(greenMail.getPop3());
        servers.add(greenMail.getImap());
        for (AbstractServer abstractServer : servers) {
            if (abstractServer == null || this.isServerRunning(abstractServer)) continue;
            greenMail.stop();
            return null;
        }
        return greenMail;
    }

    private boolean isServerRunning(AbstractServer server) {
        if (!server.isAlive()) {
            this.log.get().log((Object)("Error trying to start '" + server.getProtocol() + "' server on port '" + server.getPort() + "'."));
            return false;
        }
        this.log.get().log((Object)("Running '" + server.getProtocol() + "' server on port '" + server.getPort() + "'."));
        return true;
    }

    public void stop() {
        if (this.isRunning()) {
            this.greenMail.stop();
            this.greenMail = null;
        }
    }

    public boolean isRunning() {
        return this.greenMail != null;
    }

    public void addUser(String email, String login, String password) {
        this.greenMailUsers.add(this.greenMail.setUser(email, login, password));
    }

    public int getPop3Port() {
        return this.greenMail.getPop3().getPort();
    }

    public int getSmtpPort() {
        return this.greenMail.getSmtp().getPort();
    }

    public int getImapPort() {
        return this.greenMail.getImap().getPort();
    }

    public void sendTextMessage(String to, String from, String subject, String body) {
        MailService.sendTextEmail(to, from, subject, body, this.greenMail.getSmtp().getServerSetup());
        this.greenMail.waitForIncomingEmail(1);
    }

    public MimeMessage[] getReceivedMessages() {
        return this.greenMail.getReceivedMessages();
    }

    public MimeMessage[] getReceivedMessagesAndClear() throws FolderException {
        MimeMessage[] receivedMessages = this.greenMail.getReceivedMessages();
        this.removeAllReceivedMessages();
        return receivedMessages;
    }

    public MimeMessage getReceivedMessage() {
        MimeMessage[] receivedMail = this.getReceivedMessages();
        if (receivedMail.length == 0) {
            return null;
        }
        return receivedMail[0];
    }

    public MimeMessage waitAndGetReceivedMessage() throws InterruptedException {
        this.greenMail.waitForIncomingEmail(10000L, 1);
        return this.getReceivedMessage();
    }

    public MailFolder getUserInbox(String userEmail) throws FolderException {
        GreenMailUser mailUser = this.greenMail.setUser(userEmail, "password");
        return this.greenMail.getManagers().getImapHostManager().getInbox(mailUser);
    }

    public void removeAllReceivedMessages() throws FolderException {
        for (GreenMailUser user : this.greenMailUsers) {
            this.greenMail.getManagers().getImapHostManager().getInbox(user).deleteAllMessages();
        }
    }

    public boolean waitForIncomingMessage(int numberOfMessages) throws InterruptedException {
        return this.waitForIncomingMessage(10000L, numberOfMessages);
    }

    public boolean waitForIncomingMessage(long timeout, int numberOfMessages) throws InterruptedException {
        return this.greenMail.waitForIncomingEmail(timeout, numberOfMessages);
    }

    private static void sendTextEmail(String to, String from, String subject, String msg, ServerSetup setup) {
        try {
            Session session = MailService.getSession(setup);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setSubject(subject);
            mimeMessage.setFrom((Address)new InternetAddress(from));
            mimeMessage.setText(msg);
            Transport.send((Message)mimeMessage, (Address[])new InternetAddress[]{new InternetAddress(to)});
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Session getSession(ServerSetup setup) {
        Properties props = new Properties();
        props.put("mail.smtps.starttls.enable", Boolean.TRUE);
        if (setup.isSecure()) {
            props.setProperty("mail.smtp.socketFactory.class", DummySSLSocketFactory.class.getName());
        }
        props.setProperty("mail.transport.protocol", setup.getProtocol());
        props.setProperty("mail.smtp.host", String.valueOf(setup.getBindAddress()));
        props.setProperty("mail.smtp.port", String.valueOf(setup.getPort()));
        props.setProperty("mail.smtps.port", String.valueOf(setup.getPort()));
        return Session.getInstance((Properties)props, null);
    }
}

