/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.junit.extensions.ClearStaticsExtension;
import com.atlassian.jira.junit.extensions.Log4jLoggerExtension;
import com.atlassian.jira.junit.extensions.MockComponentContainerExtension;
import com.atlassian.jira.webtests.ztests.DummyClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.RepetitionInfo;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@WebTest(value={Category.FUNC_TEST})
@ExtendWith(value={Log4jLoggerExtension.class, ClearStaticsExtension.class, MockitoExtension.class, MockComponentContainerExtension.class})
public class JUnit5SupportTest {
    @Mock
    DummyClass dummyClass;

    @Test
    void simpleTest() {
        int result = 5;
        Assertions.assertEquals((int)5, (int)result);
    }

    static Stream<Arguments> testCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{5, true}), Arguments.of((Object[])new Object[]{4, false}), Arguments.of((Object[])new Object[]{1, false}), Arguments.of((Object[])new Object[]{0, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void parametrizedTest(int value, boolean expectedResult) {
        boolean actualResult = value == 5;
        Assertions.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    boolean trueCondition() {
        return true;
    }

    @Test
    @DisabledIf(value="trueCondition")
    void testDisabledIfConditionIsMet() {
        Assertions.fail();
    }

    @Test
    @Disabled
    void testJustDisabled() {
        Assertions.fail();
    }

    boolean falseCondition() {
        return false;
    }

    @Test
    @DisabledIf(value="falseCondition")
    void testNotDisabledIfConditionIsNotMet() {
    }

    @Test
    @Tag(value="testTag")
    void testMockitoExtension() {
        Mockito.when((Object)this.dummyClass.getInt()).thenReturn((Object)13);
        long result = this.dummyClass.getInt();
        Assertions.assertEquals((long)13L, (long)result);
    }

    @TestFactory
    Collection<DynamicTest> dynamicTestsWithCollection() {
        return Arrays.asList(DynamicTest.dynamicTest((String)"Add test", () -> Assertions.assertEquals((int)2, (int)Math.addExact(1, 1))), DynamicTest.dynamicTest((String)"Multiply Test", () -> Assertions.assertEquals((int)4, (int)Math.multiplyExact(2, 2))));
    }

    @Test
    @DisplayName(value="Test with special name")
    void namedTest() {
    }

    @RepeatedTest(value=3)
    void repeatedTest(RepetitionInfo repetitionInfo) {
        int result = 5 + repetitionInfo.getCurrentRepetition();
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5)));
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(8)));
    }

    @Test
    void testMockitoExtensionWorked() {
        Mockito.when((Object)this.dummyClass.getInt()).thenThrow(new Throwable[]{new IllegalStateException()});
        Assertions.assertThrows(IllegalStateException.class, () -> this.dummyClass.getInt());
    }

    @Nested
    @MockitoSettings(strictness=Strictness.LENIENT)
    class NestedClass {
        NestedClass() {
        }

        @Test
        void nestedTest() {
        }

        @Test
        void testStrictnessSettingsApply() {
            Mockito.when((Object)JUnit5SupportTest.this.dummyClass.getInt()).thenReturn((Object)5);
        }
    }
}

