/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.IMPORT_EXPORT})
@LoginAs(user="admin")
public class TestXmlRestore
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testRestoreDataWhereCurrentUserDoesntExist() {
        this.administration.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser("idontexist");
        this.backdoor.usersAndGroups().addUserToGroup("idontexist", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("idontexist");
        this.getTester().gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getTester().setWorkingForm("restore-xml-data-backup");
        String filePath = this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/blankprojects.xml";
        this.getTester().setFormElement("filename", filePath);
        this.getTester().setFormElement("license", LicenseKeys.COMMERCIAL_DC.getLicenseString());
        this.getTester().submit();
        this.administration.waitForRestore();
        this.getTester().assertTextPresent("Your import has been successful");
        this.getTester().assertTextNotPresent("NullPointerException");
        this.navigation.disableWebSudo();
        this.navigation.login("admin", "admin");
        this.administration.generalConfiguration().setBaseUrl(this.getBaseUrl());
    }

    private String getBaseUrl() {
        return this.getEnvironmentData().getBaseUrl().toExternalForm();
    }
}

