/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.gson.Gson;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class NonPublicFontsTest
extends BaseJiraFuncTest {
    private static final String REST_ENDPOINT = "/rest/static-asset-caching/health-checks";

    @Test
    public void noPluginsWithPrivateFonts() throws IOException, SAXException {
        GetMethodWebRequest request = new GetMethodWebRequest(this.appUrl(REST_ENDPOINT));
        WebResponse response = this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
        PluginsWithNonPublicFonts[] pluginsWithNonPublicFonts = (PluginsWithNonPublicFonts[])new Gson().fromJson(response.getText(), PluginsWithNonPublicFonts[].class);
        Assert.assertThat((String)("Found plugins with non-public foints: " + NonPublicFontsTest.describe(pluginsWithNonPublicFonts)), (Object)pluginsWithNonPublicFonts, (Matcher)Matchers.emptyArray());
    }

    private static List<String> describe(PluginsWithNonPublicFonts[] pluginsWithNonPublicFonts) {
        return Arrays.stream(pluginsWithNonPublicFonts).map(NonPublicFontsTest::describe).collect(Collectors.toList());
    }

    private static String describe(PluginsWithNonPublicFonts pluginWithNonPublicFonts) {
        String resources = Arrays.stream(pluginWithNonPublicFonts.resourcesWithNonPublicFonts).map(res -> String.format("%s:%s", res.moduleKey, Arrays.toString(res.nonPublicFontResources))).collect(Collectors.joining(","));
        return String.format("%s:%s", pluginWithNonPublicFonts.pluginKey, resources);
    }

    private String appUrl(String url) {
        return this.environmentData.getBaseUrl() + url;
    }

    private static class ResourcesWithNonPublicFonts {
        String moduleKey;
        String[] nonPublicFontResources;

        private ResourcesWithNonPublicFonts() {
        }
    }

    private static class PluginsWithNonPublicFonts {
        String pluginKey;
        ResourcesWithNonPublicFonts[] resourcesWithNonPublicFonts;

        private PluginsWithNonPublicFonts() {
        }
    }
}

