/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestAdminMenuWebFragment
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestWebFragment.xml");
    }

    @After
    public void tearDownTest() {
        this.navigation.login("admin", "admin");
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testAdminMenuWebFragment() {
        this._testSystemAdminCanSeeAllAdminSections();
        this._testProjectAdminCanSeeProjectSectionOnly();
        this._testOtherUsersCannotSeeAdminSections();
    }

    public void _testSystemAdminCanSeeAllAdminSections() {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdmin();
        this.assertAdminLinksAreVisible();
    }

    public void _testProjectAdminCanSeeProjectSectionOnly() {
        this.navigation.login("project_admin", "project_admin");
        this.navigation.gotoAdmin();
        this.assertAdminLinksAreNotVisible();
    }

    public void _testOtherUsersCannotSeeAdminSections() {
        this.navigation.login("user", "user");
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
        this.tester.assertTextPresent("You do not have the permissions to administer any projects, or there are none created.");
        this.assertAdminLinksAreNotVisible();
        this.navigation.logout();
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.aui-message-warning"), "If you log in or sign up for an account, you might be able to see more here.");
        this.assertions.assertNodeByIdDoesNotExist("adminMenu");
    }

    public void assertAdminLinksAreVisible() {
        this.tester.assertElementPresent("admin-nav-heading");
    }

    public void assertAdminLinksAreNotVisible() {
        this.tester.assertButtonNotPresent("admin-nav-heading");
    }
}

