/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.functest.rule.Rules;
import com.atlassian.jira.functest.rule.TemporaryFileRule;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.SimpleXpathEngine;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.IMPORT_EXPORT})
@LoginAs(user="admin")
public class TestDataExport
extends BaseJiraFuncTest {
    private static final String BS_BACKUP_TEST_FILE_XML = "BS_BackupTestFile.xml";
    @Inject
    private Administration administration;
    @Inject
    private EnvironmentUtils environmentUtils;
    @Rule
    public TemporaryFileRule temporaryFileRule = Rules.temporaryFile();

    @Test
    public void testNoFilename() throws Exception {
        this.tester.gotoPage("secure/admin/XmlBackup!default.jspa");
        this.tester.assertTextNotPresent("You must enter a file name to export to");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(Duration.ONE_SECOND).until(() -> new IdLocator(this.tester, "backup_submit").exists());
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", "");
        this.tester.submit();
        this.tester.assertTextPresent("You must enter a file name to export to");
    }

    @Test
    public void testInvalidFilename() throws Exception {
        if (this.environmentUtils.isOnWindows()) {
            this.tester.gotoPage("secure/admin/XmlBackup!default.jspa");
            this.tester.assertTextNotPresent("Filename 'C:\\te:st.xml' is invalid");
            this.tester.setWorkingForm("jiraform");
            this.tester.setFormElement("filename", "C:\\te:st.xml");
            this.tester.submit();
            this.tester.assertTextPresent("Filename &#39;C:\\te:st.xml&#39; is invalid");
        }
    }

    @Test
    @Restore(value="TestDataExport.xml")
    public void testDataExportDoesNotAnonymise() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File backupFile = this.administration.exportDataToFile(BS_BACKUP_TEST_FILE_XML);
        this.temporaryFileRule.add(backupFile);
        Assert.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
        Document doc = this.buildControlDocument(backupFile);
        XMLAssert.assertXpathEvaluatesTo((String)"This is a test summary to make sure that the xml backup does not anonymise this data", (String)"/entity-engine-xml/Issue[@id=10000]/@summary", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"This is a test description to make sure that the xml backup does not anonymise this data", (String)"/entity-engine-xml/Issue[@id=10000]/@description", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"This is a comment to make sure that the xml backup does not anonymise this data", (String)"/entity-engine-xml/Action[@id=10000]/@body", (Document)doc);
    }

    @Test
    @Restore(value="TestXmlBackupInvalidCommentCharacters.xml")
    public void testInvalidCharactersInComments() throws IOException, ParserConfigurationException, SAXException {
        File backupFile = this.administration.exportDataToFile(BS_BACKUP_TEST_FILE_XML);
        this.temporaryFileRule.add(backupFile);
        Assert.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
        Document doc = this.buildControlDocument(backupFile);
        this.checkForValidComments(doc.getChildNodes());
        NodeList topNode = doc.getElementsByTagName("entity-engine-xml");
        Assert.assertNotNull((Object)topNode);
        Assert.assertEquals((long)1L, (long)topNode.getLength());
        this.checkForValidComments(topNode.item(0).getChildNodes());
        FileUtils.copyFileToDirectory((File)backupFile, (File)this.environmentData.getXMLDataLocation());
        this.administration.restoreData(backupFile.getName());
    }

    @Test
    public void testServerTimezoneExport() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File backupFile = this.administration.exportDataToFile(BS_BACKUP_TEST_FILE_XML);
        this.temporaryFileRule.add(backupFile);
        Assert.assertTrue((String)"The backup file must exist", (boolean)backupFile.exists());
        Document doc = this.buildControlDocument(backupFile);
        SimpleXpathEngine xpath = new SimpleXpathEngine();
        XMLAssert.assertXpathExists((String)"/entity-engine-xml/OSPropertyEntry[@propertyKey='jvm.system.timezone']", (Document)doc);
        String timezonePropertyId = xpath.evaluate("/entity-engine-xml/OSPropertyEntry[@propertyKey='jvm.system.timezone']/@id", doc);
        XMLAssert.assertXpathExists((String)("/entity-engine-xml/OSPropertyString[@id='" + timezonePropertyId + "']"), (Document)doc);
        String zoneId = xpath.evaluate("/entity-engine-xml/OSPropertyString[@id='" + timezonePropertyId + "']/@value", doc);
        this.assertZoneIdIsValid(zoneId);
    }

    private void assertZoneIdIsValid(String zoneId) {
        Assert.assertTrue((String)("The exported timezone property doesn't contain a valid timezone id: '" + zoneId + "'"), (boolean)ZoneId.getAvailableZoneIds().contains(zoneId));
    }

    private Document buildControlDocument(File backupFile) throws IOException, SAXException, ParserConfigurationException {
        return XMLUnit.buildControlDocument((InputSource)new InputSource(new ZipFile(backupFile).getInputStream(new ZipEntry("entities.xml"))));
    }

    private void checkForValidComments(NodeList nodes) {
        boolean hasComments = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 8) continue;
            String commentText = node.getNodeValue();
            Assert.assertTrue((String)("Comment text has at least one -- in it : '" + commentText), (!commentText.contains("--") ? 1 : 0) != 0);
            hasComments = true;
        }
        Assert.assertTrue((String)"There should be comments in the data export nowdays", (boolean)hasComments);
    }
}

