/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
public class TestGeneralConfigurationSecurity
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testNonSysadminCannotAccessMimeSnifferOption() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.login("admin");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
            this.assertions.assertNodeDoesNotExist(this.locator.css("td[data-property-id=ie-mime-sniffing]"));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testNonSysadminCannotEditMimeSnifferOption() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.navigation.login("admin");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
            this.tester.clickLink("edit-app-properties");
            this.assertions.assertNodeDoesNotExist(this.locator.css("input[name=ieMimeSniffer]"));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }
}

