/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestGlobalPermissions
extends BaseJiraFuncTest {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Test
    public void testErrorOnSysAdminDelete() {
        this.administration.restoreBlankInstance();
        this.gotoGlobalPermissions();
        this.tester.assertTextPresent("Jira System Administrators");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.clickLink("del_SYSTEM_ADMIN_jira-administrators");
        this.tester.assertTextPresent("You cannot delete this permission. You are not a member of any of the other system administration permissions.");
    }

    @Test
    public void testAddThenDeletePermission() {
        this.administration.restoreBlankInstance();
        this.gotoGlobalPermissions();
        this.tester.assertTextPresent("Browse Users");
        this.tester.assertTextPresent("jira-developers");
        this.tester.assertLinkPresent("del_USER_PICKER_jira-developers");
        this.tester.selectOption("globalPermType", "Browse Users");
        this.tester.selectOption("groupName", "Anyone on the web");
        this.tester.submit("Add");
        this.tester.assertLinkPresent("del_USER_PICKER_");
        this.tester.clickLink("del_USER_PICKER_");
        this.tester.assertTextPresent("Delete Global Permission");
        this.tester.assertTextPresent("Are you sure you want to delete the");
        this.tester.assertTextPresent("Anyone on the web");
        this.tester.assertTextPresent("group from the");
        this.tester.assertTextPresent("Browse Users");
        this.tester.assertTextPresent("permission?");
        this.tester.submit("Delete");
        this.tester.assertLinkNotPresent("del_USER_PICKER_");
    }

    @Test
    public void testAddNoPermission() {
        this.administration.restoreBlankInstance();
        this.gotoGlobalPermissions();
        this.tester.submit("Add");
        this.tester.assertTextPresent("You must select a permission");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        this.tester.assertTextNotPresent("You must select a permission");
        this.tester.selectOption("globalPermType", "Please select a permission");
        this.tester.submit("Add");
        this.tester.assertTextPresent("You must select a permission");
    }

    @Test
    public void testNotAllowedToAddAnyoneToJiraUsers() {
        this.administration.restoreBlankInstance();
        this.gotoGlobalPermissions();
        this.tester.assertTextPresent("Jira Administrators");
        this.tester.assertTextPresent("jira-administrators");
        this.assertCannotAddAnyoneToJiraAdministrators();
        this.assertCannotAddAnyoneToSystemAdministrators();
    }

    private void assertCannotAddAnyoneToJiraAdministrators() {
        this.tester.selectOption("globalPermType", "Jira Administrators");
        this.tester.selectOption("groupName", "Anyone on the web");
        this.tester.submit("Add");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The group 'Anyone on the web' is not allowed to be added to the permission");
    }

    private void assertCannotAddAnyoneToSystemAdministrators() {
        this.tester.selectOption("globalPermType", "Jira System Administrators");
        this.tester.selectOption("groupName", "Anyone on the web");
        this.tester.submit("Add");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The group 'Anyone on the web' is not allowed to be added to the permission");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSystemAdminNotVisibleToNonAdmins() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            this.gotoGlobalPermissions();
            this.tester.assertTextNotPresent("<b>Jira System Administrators</b>");
            String addUrl = this.page.addXsrfToken("/secure/admin/jira/GlobalPermissions.jspa?action=add&globalPermType=SYSTEM_ADMIN&groupName=jira-users");
            this.tester.gotoPage(addUrl);
            this.tester.assertTextPresent("You can not add a group to a global permission you do not have permission to see.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testAdminCannotDeleteSysAdminGroups() {
        try {
            this.administration.restoreData("TestWithSystemAdmin.xml");
            String removeUrl = this.page.addXsrfToken("/secure/admin/jira/GlobalPermissions.jspa?globalPermType=SYSTEM_ADMIN&action=del&groupName=jira-sys-admins");
            this.tester.gotoPage(removeUrl);
            this.tester.assertTextPresent("Only system administrators can delete groups from the system administrator permission.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    public void testFilterPermsHaveCorrectVisibility() {
        this.administration.restoreBlankInstance();
        this.gotoGlobalPermissions();
        this.tester.assertTextPresent("Create Shared Objects");
        this.tester.assertTextPresent("Manage Group Filter Subscriptions");
    }

    @Test
    public void testRemoveGroupDoesntExist() {
        this.administration.restoreData("TestRemoveGroupDoesntExist.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.assertTextNotPresent("Stuff");
        this.gotoGlobalPermissions();
        this.tester.assertTextPresent("Stuff");
        this.tester.clickLink("del_USER_PICKER_Stuff");
        this.tester.assertTextPresent("Delete Global Permission");
        this.assertions.text().assertTextSequence(this.tester.getDialog().getResponseText(), "Are you sure you want to delete the", "Stuff", "group from the", "Browse Users", "permission");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Global Permissions");
        this.tester.assertTextNotPresent("Stuff");
        String removeUrl = this.page.addXsrfToken("secure/admin/jira/GlobalPermissions.jspa?groupName=bad&globalPermType=SYSTEM_ADMIN&action=confirm");
        this.tester.gotoPage(removeUrl);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Group 'bad' cannot be removed from permission 'Jira System Administrators' since it is not a member of this permission.");
    }

    private void gotoGlobalPermissions() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        this.tester.assertTextPresent("Global Permissions");
    }
}

