/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.ProgressPageControl;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueLinkCheck
extends BaseJiraFuncTest {
    public static final String CHECK = "check";
    public static final String FIX = "fix";
    public static final String BACK = "back";
    public static final String ACKNOWLEDGE = "acknowledge";
    public static final String REFRESH = "refresh";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestIssueLinkCheck.xml");
    }

    @Test
    public void testIssueLinkCheck() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.submit(CHECK);
        this.textAssertions.assertTextPresent(this.locator.page(), "Checking the integrity for 1 check.");
        ProgressPageControl.waitAndReload(this.tester, "integrity-checker-form", REFRESH, ACKNOWLEDGE);
        this.textAssertions.assertTextPresent(this.locator.page(), "Choose the errors you would like to fix, or return to the previous screen");
        this.textAssertions.assertTextPresent(this.locator.page(), "The following Issue Link will be removed due to a related invalid issue: IssueLink (ID:10002)");
        this.textAssertions.assertTextPresent(this.locator.page(), "The following Issue Link will be removed due to a related invalid issue: IssueLink (ID:10003)");
        this.textAssertions.assertTextPresent(this.locator.page(), "The following Issue Link will be removed due to a related invalid issue: IssueLink (ID:10004)");
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.submit(FIX);
        this.textAssertions.assertTextPresent(this.locator.page(), "Fixing the integrity for 1 check.");
        ProgressPageControl.waitAndReload(this.tester, "integrity-checker-form", REFRESH, ACKNOWLEDGE);
        this.textAssertions.assertTextPresent(this.locator.page(), "3 error(s) were corrected");
        this.textAssertions.assertTextPresent(this.locator.page(), "The following Issue Link has been removed due to a related invalid issue: IssueLink (ID:10002)");
        this.textAssertions.assertTextPresent(this.locator.page(), "The following Issue Link has been removed due to a related invalid issue: IssueLink (ID:10003)");
        this.textAssertions.assertTextPresent(this.locator.page(), "The following Issue Link has been removed due to a related invalid issue: IssueLink (ID:10004)");
        this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
        this.tester.checkCheckbox("integrity_check_1_3", "3");
        this.tester.submit(CHECK);
        this.textAssertions.assertTextPresent(this.locator.page(), "Checking the integrity for 1 check.");
        ProgressPageControl.waitAndReload(this.tester, "integrity-checker-form", REFRESH, ACKNOWLEDGE);
        this.textAssertions.assertTextPresent(this.locator.page(), "No errors were found");
        this.textAssertions.assertTextSequence(this.locator.page(), "PASSED", "Check that all Issue Links are associated with valid issues");
        this.tester.submit(BACK);
        this.textAssertions.assertTextPresent("Select one or more integrity checks from the list below to check for out of date information in the database.");
    }
}

