/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
@LoginAs(user="admin")
public class TestIssueType
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void init() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPES);
    }

    @Test
    public void testSameName() throws Exception {
        this.tester.clickLink("add-issue-type");
        this.addIssueType("Bug");
        this.assertDuplicateIssueTypeErrorAui();
        this.addIssueType("bUG");
        this.assertDuplicateIssueTypeErrorAui();
        this.tester.gotoPage("secure/admin/EditIssueType!default.jspa?id=4");
        this.tester.setFormElement("name", "Bug");
        this.tester.submit();
        this.assertDuplicateIssueTypeErrorAui();
        this.tester.setFormElement("name", "BUG");
        this.tester.submit();
        this.assertDuplicateIssueTypeErrorAui();
    }

    @Test
    public void testIssueTypeOrderedByStyleAndName() {
        this.backdoor.subtask().enable();
        this.addTaskIssueType("Heroic mission on Mars");
        this.addTaskIssueType("another Heroic mission on Mars");
        this.addTaskIssueType("Heroic mission on Bruce Willis Asteroid");
        this.addTaskIssueType("Tell interesting story, Mark");
        this.addTaskIssueType("Kill all humans task");
        this.addSubtaskIssueType("And other lifeforms");
        this.addSubtaskIssueType("a little but important subtask");
        this.addSubtaskIssueType("Also kill all mutants");
        this.assertions.text().assertTextSequence(new IdLocator(this.tester, "issue-types-table"), "Heroic mission on Bruce Willis Asteroid", "Heroic mission on Mars", "Kill all humans task", "Tell interesting story, Mark", "another Heroic mission on Mars", "Also kill all mutants", "And other lifeforms", "a little but important subtask");
    }

    @Test
    public void testCanNotAddIssueTypeWithEmptyName() {
        this.tester.clickLink("add-issue-type");
        this.tester.setFormElement("name", "");
        this.tester.submit();
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("You must specify a name.");
    }

    private void assertDuplicateIssueTypeError() {
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("This name is already taken.");
    }

    private void assertDuplicateIssueTypeErrorAui() {
        this.assertions.getJiraFormAssertions().assertAuiFieldErrMsg("This name is already taken.");
    }

    private void addIssueType(String name) {
        this.tester.setFormElement("name", name);
        this.tester.submit();
    }

    private void addSubtaskIssueType(String name) {
        this.tester.clickLink("add-issue-type");
        this.tester.setFormElement("name", name);
        this.tester.checkRadioOption("style", "jira_subtask");
        this.tester.submit();
    }

    private void addTaskIssueType(String name) {
        this.tester.clickLink("add-issue-type");
        this.tester.setFormElement("name", name);
        this.tester.checkRadioOption("style", "");
        this.tester.submit();
    }
}

