/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestModz
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testChangedFiles() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.SYSTEM_INFO);
        TableLocator locator = new TableLocator(this.tester, "system_info_table");
        this.textAssertions.assertTextPresent(locator, "There have been no removed files");
        this.textAssertions.assertTextNotPresent(locator, "WEB-INF/classes");
    }

    private void turnOffDebug() {
        this.tester.gotoPage("/secure/admin/jira/ConfigureLogging!default.jspa?loggerName=com.atlassian");
        this.tester.selectOption("levelName", "WARN");
    }

    private void turnOnDebug() {
        this.tester.gotoPage("/secure/admin/jira/ConfigureLogging!default.jspa?loggerName=com.atlassian");
        this.tester.selectOption("levelName", "DEBUG");
        this.tester.submit("Update");
    }
}

