/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.allowlisthost;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.webtests.ztests.admin.allowlisthost.TestProjectForSelfField;
import com.atlassian.jira.webtests.ztests.admin.allowlisthost.WhitelistRestCallHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestAllowHostList.xml")
public class TestIssueForSelfField
extends BaseJiraFuncTest {
    private static final String TEMPORARY_BASE_URL_HOST = "host";
    private static final String WHITE_LIST_HOST = "white";
    private static final String ALLOW_LIST = "ALLOW_LIST";
    private static final String HOST_FROM_REQUEST = "HOST_FROM_REQUEST";
    private static final String BASEURL = "BASEURL";
    private static final String ISSUE_KEY = "HSP-2";
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeAllowHost() {
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", ALLOW_LIST);
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        Assert.assertEquals((Object)ISSUE_KEY, (Object)issue.key);
        this.checkSelfFields(this.environmentData.getBaseUrl(), issue);
    }

    @Test
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeBaseUrl() throws URISyntaxException {
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", BASEURL);
        this.administration.generalConfiguration().setBaseUrl(this.createTemporaryBaseUrl());
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        Assert.assertEquals((Object)ISSUE_KEY, (Object)issue.key);
        Assert.assertNotEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/HSP-2/watchers"), (Object)issue.fields.watches.self);
        this.checkSelfFields(this.createTemporaryBaseUrl(), issue);
        this.administration.generalConfiguration().fixBaseUrl();
    }

    @Test
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeExisting() {
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", HOST_FROM_REQUEST);
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        Assert.assertEquals((Object)ISSUE_KEY, (Object)issue.key);
        this.checkSelfFields(this.environmentData.getBaseUrl(), issue);
    }

    @Test
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeAllowHostAndHostIsNotOnTheAllowList() throws IOException {
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", ALLOW_LIST);
        try (CloseableHttpResponse response = TestProjectForSelfField.getCustomFieldOption(issue.key, TEMPORARY_BASE_URL_HOST, "issue", this.environmentData.getBaseUrl().toString());){
            Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeAllowHostAndHostIsOnTheAllowList() throws IOException {
        WhitelistRestCallHelper.addNewWhitelistItem(this.getEnvironmentData().getBaseUrl().toString(), WHITE_LIST_HOST);
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", ALLOW_LIST);
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        try (CloseableHttpResponse response = TestProjectForSelfField.getCustomFieldOption(issue.key, WHITE_LIST_HOST, "issue", this.environmentData.getBaseUrl().toString());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    public void testSelfValuesForIssueForBaseUrlWhenThereIsAPort() {
        String baseUrl = "http://localhost:1111/jira";
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", BASEURL);
        this.backdoor.applicationProperties().setString("jira.baseurl", baseUrl);
        Issue issue = this.issueClient.get(ISSUE_KEY, new Issue.Expand[0]);
        this.checkSelfFields(baseUrl, issue);
    }

    private void checkSelfFields(Object baseUrl, Issue issue) {
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/issue/" + issue.id), (Object)issue.self);
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/project/" + issue.fields.project.id), (Object)issue.fields.project.self);
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/issue/HSP-2/votes"), (Object)issue.fields.votes.self);
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/issue/HSP-2/watchers"), (Object)issue.fields.watches.self);
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/priority/3"), (Object)issue.fields.priority.self());
        Assert.assertEquals((Object)(baseUrl + "/images/icons/priorities/major.svg"), (Object)issue.fields.priority.iconUrl());
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/status/1"), (Object)issue.fields.status.self());
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/statuscategory/2"), (Object)issue.fields.status.statusCategory().self());
        Assert.assertTrue((boolean)((String)issue.fields.project.avatarUrls.get("48x48")).contains(baseUrl + "/secure/projectavatar?pid=" + issue.fields.project.id + "&avatarId"));
    }

    private String createTemporaryBaseUrl() throws URISyntaxException {
        return UriBuilder.fromUri((URI)this.environmentData.getBaseUrl().toURI()).host(TEMPORARY_BASE_URL_HOST).build(new Object[0]).toString();
    }
}

