/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.allowlisthost;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.webtests.ztests.admin.allowlisthost.WhitelistRestCallHelper;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestAllowHostList.xml")
public class TestProjectForSelfField
extends BaseJiraFuncTest {
    public static final String TEMPORARY_BASE_URL_HOST = "valid-host";
    public static final String WHITE_LIST_HOST = "white";
    public static final String ALLOW_LIST = "ALLOW_LIST";
    public static final String HOST_FROM_REQUEST = "HOST_FROM_REQUEST";
    public static final String BASEURL = "BASEURL";
    private ProjectClient projectClient;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.projectClient = new ProjectClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @Test
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeAllowHost() {
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", ALLOW_LIST);
        Project project = this.projectClient.get("HSP");
        this.checkSelfFields(this.environmentData.getBaseUrl(), project);
    }

    @Test
    @LoginAs(user="admin")
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeBaseUrl() {
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", BASEURL);
        this.administration.generalConfiguration().setBaseUrl(TestProjectForSelfField.createTemporaryBaseUrl(TEMPORARY_BASE_URL_HOST, this.getEnvironmentData().getBaseUrl().toString()));
        Project project = this.projectClient.get("HSP");
        this.checkSelfFields(TestProjectForSelfField.createTemporaryBaseUrl(TEMPORARY_BASE_URL_HOST, this.getEnvironmentData().getBaseUrl().toString()), project);
        this.administration.generalConfiguration().fixBaseUrl();
    }

    @Test
    @LoginAs(user="admin")
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeExisting() {
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", HOST_FROM_REQUEST);
        Project project = this.projectClient.get("HSP");
        this.checkSelfFields(this.environmentData.getBaseUrl(), project);
    }

    @Test
    @LoginAs(user="admin")
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeAllowHostAndHostIsNotOnTheAllowList() throws IOException {
        Project project = this.projectClient.get("HSP");
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", ALLOW_LIST);
        try (CloseableHttpResponse response = TestProjectForSelfField.getCustomFieldOption(project.key, TEMPORARY_BASE_URL_HOST, "project", this.environmentData.getBaseUrl().toString());){
            Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test
    @LoginAs(user="admin")
    public void testSelfValuesForIssueAndFieldsOfIssueWhenSelfCreationTypeAllowHostAndHostIsOnTheAllowList() throws IOException {
        WhitelistRestCallHelper.addNewWhitelistItem(this.getEnvironmentData().getBaseUrl().toString(), WHITE_LIST_HOST);
        Project project = this.projectClient.get("HSP");
        this.backdoor.applicationProperties().setString("jira.self.url.origin.type", ALLOW_LIST);
        try (CloseableHttpResponse response = TestProjectForSelfField.getCustomFieldOption(project.key, WHITE_LIST_HOST, "project", this.environmentData.getBaseUrl().toString());){
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        }
    }

    private void checkSelfFields(Object baseUrl, Project project) {
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/project/" + project.id), (Object)project.self);
        Assert.assertEquals((Object)(baseUrl + "/rest/api/2/issuetype/" + ((IssueType)project.issueTypes.get((int)0)).id), (Object)((IssueType)project.issueTypes.get((int)0)).self);
        Assert.assertTrue((boolean)((String)project.avatarUrls.get("48x48")).contains(baseUrl + "/secure/projectavatar?pid=" + project.id + "&avatarId"));
    }

    static String createTemporaryBaseUrl(String host, String baseURL) {
        return UriBuilder.fromUri((String)baseURL).host(host).build(new Object[0]).toString();
    }

    /*
     * Exception decompiling
     */
    static CloseableHttpResponse getCustomFieldOption(String key, String host, String path, String baseUrl) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

