/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.audit;

import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.AdvancedAuditingClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.admin.AuditingClient;
import com.atlassian.jira.webtests.ztests.admin.audit.MockAuditRecordBean;
import com.atlassian.jira.webtests.ztests.admin.audit.TestingAuditRecord;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION})
public class AuditLoggerTest
extends BaseJiraFuncTest {
    private final MyAuditingClient auditingClient = new MyAuditingClient();
    private static final String EVENT_SUMMARY = "AuditLoggerTest";
    private static final int NUMBER_OF_RECORDS_TO_ADD = 10;

    @Test
    @RestoreBlankInstance
    public void testAuditLogDescription2000IsOKInThisDb() throws JSONException, IOException {
        TestingAuditRecord auditRecord = new TestingAuditRecord();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            s.append('i');
        }
        String desc = s.toString();
        auditRecord.setDescription(desc);
        MockAuditRecordBean bean = new MockAuditRecordBean(auditRecord, AuditingCategory.AUDITING.name());
        bean.setDescription(desc);
        this.auditingClient.postBean(bean);
        AdvancedAuditingClient.AuditEntities eventEntry = this.backdoor.advancedAuditing().waitUntilEventIsFound(EVENT_SUMMARY);
        AdvancedAuditingClient.AuditExtraAttributes extraAttributes = eventEntry.getExtraAttributes().get(0);
        MatcherAssert.assertThat((Object)extraAttributes.getName(), (Matcher)CoreMatchers.is((Object)"Description"));
        MatcherAssert.assertThat((Object)extraAttributes.getValue(), (Matcher)CoreMatchers.is((Object)desc));
    }

    @Test
    @RestoreBlankInstance
    public void testAuditingFilteringByProject() throws JSONException, IOException {
        this.auditingClient.loginAs("admin");
        for (int i = 0; i < 10; ++i) {
            TestingAuditRecord auditRecord = new TestingAuditRecord();
            String desc = Long.toString(i);
            auditRecord.setDescription(desc);
            MockAuditRecordBean bean = i < 3 ? new MockAuditRecordBean(auditRecord, AuditingCategory.AUDITING.name(), 10000L) : new MockAuditRecordBean(auditRecord, AuditingCategory.AUDITING.name(), 10001L);
            bean.setDescription(desc);
            this.auditingClient.postBean(bean);
        }
        DateTime fromTime = DateTime.now().minusDays(1);
        DateTime toTime = DateTime.now().plusSeconds(1);
        this.assertCorrectNumberOfEventsForProjectsIsFound(10000L, 3);
        this.assertCorrectNumberOfEventsForProjectsIsFound(10001L, 7);
        MatcherAssert.assertThat(this.auditingClient.getViewResponse(EVENT_SUMMARY, fromTime, toTime, (List<Long>)ImmutableList.of((Object)10000L, (Object)10001L)).getRecords(), (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat(this.auditingClient.getViewResponse(EVENT_SUMMARY, fromTime, toTime, (List<Long>)ImmutableList.of((Object)10000L, (Object)10001L), 3L).getRecords(), (Matcher)Matchers.hasSize((int)3));
    }

    private void assertCorrectNumberOfEventsForProjectsIsFound(long projectId, int numberOfEvents) {
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).pollInterval(Duration.TWO_SECONDS).until(() -> this.auditingClient.getViewResponseForProject(projectId).getRecords().size() == numberOfEvents);
    }

    private class MyAuditingClient
    extends AuditingClient {
        public MyAuditingClient() {
            super(AuditLoggerTest.this.getEnvironmentData());
        }

        @Override
        protected WebTarget createResource() {
            return this.resourceRoot(AuditLoggerTest.this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("latest").path("auditing").path("record");
        }

        public void postBean(Object bean) throws JSONException, IOException {
            WebTarget resource = this.createResource();
            ObjectMapper objectMapper = new ObjectMapper();
            String requestEntity = objectMapper.writeValueAsString(bean);
            resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)requestEntity), String.class);
        }
    }
}

