/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.instrumentation;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestViewInstrumentation
extends BaseJiraFuncTest {
    private static final String ERROR_403_MESSAGE = "HTTPError403";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Test
    public void testViewInstrumentationNotXsrfable() {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("/secure/admin/ViewInstrumentation.jspa?threadContentionMonitoring=true");
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
        this.tester.gotoPage("/secure/admin/ViewInstrumentation.jspa?threadContentionMonitoring=false");
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
    }

    @Test
    public void testViewInstrumentationWorksWithToken() {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/ViewInstrumentation.jspa?threadContentionMonitoring=true"));
        this.tester.assertTextPresent("Turn Thread Contention And CPU Monitoring Off");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/ViewInstrumentation.jspa?threadContentionMonitoring=false"));
        this.tester.assertTextPresent("Turn Thread Contention And CPU Monitoring On");
    }
}

