/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.ProgressBar;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES, Category.SCHEMES})
@LoginAs(user="admin")
public class TestIssueTypeSchemeMigration
extends BaseJiraFuncTest {
    @Rule
    public IssueTypeUrls urls = new IssueTypeUrls();
    @Inject
    private HtmlPage page;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Form form;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private ProgressBar progressBar;

    @Test
    public void testI18n() {
        this.administration.restoreI18nData("TestIssueTypeSchemeMigrationGerman.xml");
        this.urls.invalidateIssueTypeIconsCache();
        String baseUrl = this.getEnvironmentData().getBaseUrl().toString();
        this.logger.log((Object)("Setting baseurl to '" + baseUrl + "'"));
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.assertions.assertNodeByIdHasText("edit-app-properties", "Einstellungen bearbeiten");
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit("Aktualisieren");
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "monkey");
        this.tester.submit(" OK ");
        this.tester.submit("nextBtn");
        this.assertCurrentStep(2);
        this.tester.submit("previousBtn");
        this.assertCurrentStep(1);
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.assertCurrentStep(4);
        XPathLocator finishLocator = this.locator.xpath("//*[@id=\"nextButton\" and @value=\"Fertigstellen\"]");
        Assert.assertNotNull((Object)finishLocator.getNode());
        this.tester.submit("nextBtn");
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
    }

    private void assertCurrentStep(int step) {
        XPathLocator locator = new XPathLocator(this.tester, "//*[@id=\"currentStep\" and @value=" + step + " ]");
        Assert.assertNotNull((Object)locator.getNode());
    }

    @Test
    public void testIssueTypeOptionsCorrectForIssueTypeMapping() {
        this.administration.restoreData("TestIssueTypeSchemeMigration.xml");
        this.urls.invalidateIssueTypeIconsCache();
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "Issue Type Scheme to Move to");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration");
        this.textAssertions.assertTextPresent(this.locator.id("summary_table"), "New Feature");
        this.textAssertions.assertTextPresent(this.locator.id("summary_table"), "Sub-task ORIG");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextPresent(this.locator.css(".jiraform .instructions"), "Sub-task ORIG");
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Another Subtask", "Sub-task DIFFERENT"});
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextPresent(this.locator.css(".jiraform .instructions"), "New Feature");
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Improvement", "Bug"});
    }

    @Test
    public void testIssueTypeSchemeMigrationNoSubtasksMultiProjects() throws SAXException {
        this.administration.restoreData("TestIssueTypeSchemeMigrationNoSubtasks.xml");
        this.urls.invalidateIssueTypeIconsCache();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 1, 0, this.urls.getIssueTypeUrl("sub-task"));
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 2, 0, this.urls.getIssueTypeUrl("new feature"));
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 3, 0, this.urls.getIssueTypeUrl("ignore3"));
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 4, 0, this.urls.getIssueTypeUrl("bug"));
        this.navigation.issue().gotoIssue("HSP-4");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Another Subtask");
        this.navigation.issue().gotoIssue("HSP-3");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "New Feature");
        this.navigation.issue().gotoIssue("HSP-2");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Sub-task ORIG");
        this.navigation.issue().gotoIssue("HSP-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Bug");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10030");
        this.form.selectOptionsByValue("projects", new String[]{"10000", "10001"});
        this.tester.submit("Associate");
        this.tester.assertTextPresent("There are 2 sub-tasks that will be affected by this change. You must have at least one valid sub-task issue type.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10020");
        this.form.selectOptionsByValue("projects", new String[]{"10000", "10001"});
        this.tester.submit("Associate");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Overview (Step 1 of 6)", "homosapien", "New Feature", "1", "homosapien", "Sub-task ORIG", "1");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Select Issue Type (Step 2 of 6)", "Select a new issue type for issues with current issue type ", "Sub-task ORIG", " in project ", "homosapien");
        this.navigation.issue().selectIssueType("Sub-task DIFFERENT");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Update Fields (Step 3 of 6)", "Update fields for issues with current issue type ", "Sub-task ORIG", " in project ", "homosapien.");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Select Issue Type (Step 4 of 6)", "Select a new issue type for issues with current issue type ", "New Feature", " in project ", "homosapien");
        this.navigation.issue().selectIssueType("Bug");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Update Fields (Step 5 of 6)", "Update fields for issues with current issue type ", "New Feature", " in project ", "homosapien.");
        this.tester.assertTextPresent("All field values will be retained.");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue type schemes", "An issue type scheme determines which issue types will be available to a set of projects. It also allows to specify the order in which the issue types are presented in the user interface.");
        this.navigation.issueNavigator().displayAllIssues();
        issueTable = this.tester.getDialog().getResponse().getTableWithID("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 1, 0, this.urls.getIssueTypeUrl("sub-task"));
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 2, 0, this.urls.getIssueTypeUrl("bug"));
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 3, 0, this.urls.getIssueTypeUrl("ignore3"));
        this.assertions.getTableAssertions().assertTableCellHasImage(issueTable, 4, 0, this.urls.getIssueTypeUrl("bug"));
        this.navigation.issue().gotoIssue("HSP-4");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Another Subtask");
        this.navigation.issue().gotoIssue("HSP-3");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Bug");
        this.navigation.issue().gotoIssue("HSP-2");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Sub-task DIFFERENT");
        this.navigation.issue().gotoIssue("HSP-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type:", "Bug");
    }

    @Test
    public void testIssueTypeSchemeMigrationMultiProjectsSecurityLevels() {
        this.administration.restoreData("TestIssueTypeSchemeMigrationSecurityLevel.xml");
        this.urls.invalidateIssueTypeIconsCache();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertPrecondition();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10060");
        this.form.selectOptionsByValue("projects", new String[]{"10000", "10020", "10021", "10022"});
        this.tester.submit("Associate");
        this.tester.assertTextPresent("There are 5 sub-tasks that will be affected by this change. You must have at least one valid sub-task issue type.");
        this.assertPrecondition();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10061");
        this.form.selectOptionsByValue("projects", new String[]{"10000", "10020", "10021", "10022"});
        this.tester.submit("Associate");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Overview (Step 1 of 6)", "Bovine", "Sub-task", "3", "Rattus", "Sub-task", "2");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Select a new issue type for issues with current issue type ", "Sub-task", "in project ", "Bovine");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Update Fields (Step 3 of 6)", "All field values will be retained.");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Select Issue Type (Step 4 of 6)", "Select a new issue type for issues with current issue type ", "Sub-task", "in project", "Rattus");
        this.tester.submit("nextBtn");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), "Issue Type Migration: Update Fields (Step 5 of 6)", "All field values will be retained.");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        long submittedTaskId = this.progressBar.getSubmittedTaskId();
        this.progressBar.waitForTaskAcknowledgement(submittedTaskId);
        this.assertPrecondition();
        this.navigation.issue().gotoIssue("RAT-7");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security", "Level Mouse");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "DIFFERENT SUBTASK");
        this.navigation.issue().gotoIssue("COW-36");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Security", "MyFriendsOnly");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "DIFFERENT SUBTASK");
    }

    @Test
    public void testIssueTypeMigrationWithNumericCustomField() {
        this.administration.restoreData("TestIssueTypeMigrationWithNumericCustomField.xml");
        this.urls.invalidateIssueTypeIconsCache();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLinkWithText("Issue Type Schemes");
        this.tester.clickLink("associate_10001");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("customfield_10000", "LOREM_IPSUM");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("&#39;LOREM_IPSUM&#39; is an invalid number");
        this.tester.assertTextPresent("Issue Type Migration: Update Fields (Step 3 of 4)");
        this.tester.setFormElement("customfield_10000", "857");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Issue Type Migration: Confirmation (Step 4 of 4)");
        this.tester.assertTextPresent("857");
    }

    @Test
    public void testIssueTypeSchemeMigrationWithSubtasks() throws SAXException {
        this.administration.restoreData("TestIssueTypeSchemeMigrationWithSubtasks.xml");
        this.urls.invalidateIssueTypeIconsCache();
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.selectOption("schemeId", "Issue Type Scheme to Move to");
        this.tester.submit(" OK ");
        this.tester.assertTextPresent("Issue Type Migration");
        WebTable summaryTable = this.tester.getDialog().getResponse().getTableWithID("summary_table");
        this.assertions.getTableAssertions().assertTableCellHasText(summaryTable, 1, 1, "Bug");
        this.assertions.getTableAssertions().assertTableCellHasText(summaryTable, 2, 1, "Sub-task ORIG");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Issue Type Migration");
        this.navigation.issue().selectIssueType("New Feature");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("Issue Type Migration");
        this.navigation.issue().selectIssueType("Sub-task DIFFERENT");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextPresent("New Feature");
        this.navigation.issue().gotoIssue("HSP-2");
        this.tester.assertTextPresent("Sub-task DIFFERENT");
    }

    private void assertPrecondition() {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issuetable = this.tester.getDialog().getWebTableBySummaryOrId("issuetable");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 1, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 2, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 3, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 4, 1, "COW-37");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 4, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 4, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 4, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 5, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 5, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 5, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 5, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 6, 1, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 6, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 6, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 7, 1, "COW-34");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 7, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 7, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issuetable, 7, 11, "MyFriendsOnly");
    }
}

