/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.issuetypes;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.ISSUES, Category.ISSUE_TYPES})
@LoginAs(user="admin")
public class TestMultiIssueTypes
extends BaseJiraFuncTest {
    private static final String AUTO_CREATED_SCHEME_PREFIX = "New issue type scheme for project ";
    private static final String CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR = "#content > header.aui-page-header h1";
    private static final String VIEW_ISSUE_PAGE_ISSUE_TYPE_LABEL_ID = "type-val";
    @Inject
    private Form form;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @After
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testMultiIssueTypes() throws Exception {
        this._testCreateNewIssueTypeScheme();
        this._testSameAsProject();
        this._testChooseScheme();
    }

    private void _testChooseScheme() {
        this.logger.log((Object)"Testing choosing scheme from a list & that all available projects share the same config");
        Long mkyProjectId = this.backdoor.project().getProjectId("MKY");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + mkyProjectId);
        this.tester.checkCheckbox("createType", "createScheme");
        this.tester.selectOption("selectedOptions", "Task");
        this.tester.submit();
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)mkyProjectId).issueTypeScheme.name, (Matcher)CoreMatchers.equalTo((Object)"New issue type scheme for project monkey"));
        Long hspProjectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + hspProjectId);
        this.tester.selectOption("schemeId", "New issue type scheme for project monkey");
        this.tester.submit();
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)hspProjectId).issueTypeScheme.name, (Matcher)CoreMatchers.equalTo((Object)"New issue type scheme for project monkey"));
        this.navigation.issue().goToCreateIssueForm("homosapien", "Task");
        this.textAssertions.assertTextPresent(this.locator.css(CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR), "Create Issue");
    }

    private void _testSameAsProject() {
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.logger.log((Object)"Choose issue type scheme same as another project");
        this.tester.checkCheckbox("createType", "chooseProject");
        this.tester.selectOption("sameAsProjectId", "monkey");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "Default Issue Type Scheme");
        this.navigation.issue().goToCreateIssueForm("homosapien", "Task");
        this.textAssertions.assertTextPresent(this.locator.css(CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR), "Create Issue");
    }

    private void _testCreateNewIssueTypeScheme() {
        this.logger.log((Object)"Create a new issue type scheme");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "createScheme");
        this.form.selectOptionsByDisplayName("selectedOptions", new String[]{"Bug", "Improvement"});
        this.tester.submit();
        Assert.assertThat((Object)this.backdoor.project().getSchemes((Long)projectId).issueTypeScheme.name, (Matcher)CoreMatchers.equalTo((Object)"New issue type scheme for project homosapien"));
        if (new IdLocator(this.tester, "leave_admin").hasNodes()) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.navigation.issue().selectProject("homosapien");
        this.navigation.issue().selectIssueType("Task");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "The issue type selected is invalid");
        this.navigation.issue().selectIssueType("Bug");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.css(CREATE_ISSUE_FORM_HEADER_CSS_LOCATOR), "Create Issue");
    }

    @Test
    public void testMultipleIssueTypeSchemesWithoutBulkChangePermission() {
        this.administration.restoreData("TestIssueTypesSchemes.xml");
        this.administration.removeGlobalPermission(33, "jira-users");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCHEMES);
        this.tester.clickLink("associate_10011");
        this.tester.selectOption("projects", "homosapien");
        this.tester.submit("Associate");
        this.tester.assertTextPresent("homosapien");
        this.tester.assertTextPresent("Bug");
        this.tester.assertTextPresent("1");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.submit("nextBtn");
        this.tester.assertTextPresent("homosapien");
        this.tester.assertTextPresent("New Feature");
        this.tester.submit("nextBtn");
        this.navigation.issue().viewIssue("HSP-1");
        this.textAssertions.assertTextPresent(this.locator.id(VIEW_ISSUE_PAGE_ISSUE_TYPE_LABEL_ID), "New Feature");
    }
}

