/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfAdminGroups
extends BaseJiraFuncTest {
    @Inject
    private Form form;

    @Test
    public void testAdminGroups() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Add Group", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminGroups.this.gotoGroupBrowser();
                TestXsrfAdminGroups.this.tester.setFormElement("addName", "newgroup");
            }
        }, new XsrfCheck.FormSubmission("add_group")), new XsrfCheck("Delete Group", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminGroups.this.gotoGroupBrowser();
                TestXsrfAdminGroups.this.tester.clickLink("del_newgroup");
            }
        }, new XsrfCheck.FormSubmission("Delete")), new XsrfCheck("Bulk Edit User Groups (Leave)", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminGroups.this.gotoGroupBrowser();
                TestXsrfAdminGroups.this.tester.clickLink("edit_members_of_jira-developers");
                TestXsrfAdminGroups.this.tester.selectOption("usersToUnassign", "admin");
            }
        }, new XsrfCheck.FormSubmission("unassign")), new XsrfCheck("Bulk Edit User Groups (Join)", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminGroups.this.gotoGroupBrowser();
                TestXsrfAdminGroups.this.tester.clickLink("edit_members_of_jira-developers");
            }
        }, new XsrfCheck.FormSubmission("assign"))).run(this.tester, this.navigation, this.form);
    }

    private void gotoGroupBrowser() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
    }
}

