/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfAdminSharedFilters
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    private Form form;

    private String addFilterSharedWithAllJiraUsers() {
        return this.backdoor.filters().createFilter("", "Public Filter - Owner: Admin", "admin", "jira-users");
    }

    @Test
    public void testSharedFilterOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Delete Shared Filter", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                String filterId = TestXsrfAdminSharedFilters.this.addFilterSharedWithAllJiraUsers();
                TestXsrfAdminSharedFilters.this.administration.sharedFilters().goTo();
                TestXsrfAdminSharedFilters.this.tester.clickLink("delete_" + filterId);
                TestXsrfAdminSharedFilters.this.tester.setWorkingForm("delete-filter-confirm-form-" + filterId);
            }
        }, new XsrfCheck.FormSubmissionWithId("delete-filter-submit"))).run(this.tester, this.navigation, this.form);
    }

    private static class Data {
        private static final String SHARED_PUBLIC_FILTER_NAME = "Public Filter - Owner: Admin";

        private Data() {
        }
    }
}

