/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfEvents
extends BaseJiraFuncTest {
    @Inject
    private Form form;

    @Test
    public void testEventAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddEvent", new EventSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfEvents.this.tester.setWorkingForm("jiraform");
                TestXsrfEvents.this.tester.setFormElement("name", "New Event");
                TestXsrfEvents.this.tester.selectOption("templateId", "Issue Created");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditEvent", new EventSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfEvents.this.tester.clickLink("edit_New Event");
                TestXsrfEvents.this.tester.setFormElement("description", "This is a New Event");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("DeleteEvent", new EventSetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfEvents.this.tester.clickLink("del_New Event");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.getTester(), this.navigation, this.form);
    }

    private class EventSetup
    implements XsrfCheck.Setup {
        private EventSetup() {
        }

        @Override
        public void setup() {
            TestXsrfEvents.this.navigation.gotoAdminSection(Navigation.AdminSection.EVENTTYPES);
        }
    }
}

