/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfProjectCategories
extends BaseJiraFuncTest {
    @Inject
    private Form form;

    @Test
    public void testProjectCategoryAdministration() throws Exception {
        new XsrfTestSuite(new XsrfCheck("AddCategory", new ProjectCategorySetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfProjectCategories.this.tester.setFormElement("name", "New Category");
            }
        }, new XsrfCheck.FormSubmission("Add")), new XsrfCheck("EditCategory", new ProjectCategorySetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfProjectCategories.this.navigation.clickLinkWithExactText("Edit");
                TestXsrfProjectCategories.this.tester.setFormElement("description", "This is a category!");
            }
        }, new XsrfCheck.FormSubmission("Update")), new XsrfCheck("DeleteCategory", new ProjectCategorySetup(){

            @Override
            public void setup() {
                super.setup();
                TestXsrfProjectCategories.this.navigation.clickLinkWithExactText("Delete");
            }
        }, new XsrfCheck.FormSubmission("Delete"))).run(this.getTester(), this.navigation, this.form);
    }

    class ProjectCategorySetup
    implements XsrfCheck.Setup {
        ProjectCategorySetup() {
        }

        @Override
        public void setup() {
            TestXsrfProjectCategories.this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CATEGORIES);
            TestXsrfProjectCategories.this.tester.setWorkingForm("jiraform");
        }
    }
}

