/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfSystemOps
extends BaseJiraFuncTest {
    @Inject
    protected LocatorFactory locator;
    @Inject
    private Form form;

    @Test
    public void testSystemOps() throws Exception {
        ArrayList<XsrfCheck> xsrfChecks = new ArrayList<XsrfCheck>();
        xsrfChecks.add(new XsrfCheck("Integrity Checker", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.INTEGRITY_CHECKER);
            }
        }, new XsrfCheck.FormSubmission("check")));
        xsrfChecks.add(new XsrfCheck("Add Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LISTENERS);
            }
        }, new XsrfCheck.FormSubmission("Add")));
        xsrfChecks.add(new XsrfCheck("Edit Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LISTENERS);
                TestXsrfSystemOps.this.tester.setFormElement("name", "l1");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.event.listeners.DebugParamListener");
                TestXsrfSystemOps.this.tester.submit("Add");
                XPathLocator xPathLocator = TestXsrfSystemOps.this.locator.xpath("//tr[td/b/text()='l1']//ul[@class='operations-list']//a[text()='Edit']");
                String editId = xPathLocator.getNodes()[0].getAttributes().getNamedItem("id").getNodeValue();
                TestXsrfSystemOps.this.tester.clickLink(editId);
            }
        }, new XsrfCheck.FormSubmission("Update")));
        xsrfChecks.add(new XsrfCheck("Delete Listener", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.gotoHome();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.LISTENERS);
                TestXsrfSystemOps.this.tester.setFormElement("name", "ldel");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.event.listeners.DebugParamListener");
                TestXsrfSystemOps.this.tester.submit("Add");
                TestXsrfSystemOps.this.tester.clickLink("listeners");
            }
        }, new XsrfCheck.LinkWithTextSubmission("Delete")));
        xsrfChecks.add(new XsrfCheck("Mail Queue Flush", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.gotoHome();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.MAIL_QUEUE);
            }
        }, new XsrfCheck.LinkWithTextSubmission("Flush mail queue")));
        xsrfChecks.add(new XsrfCheck("Add Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
                TestXsrfSystemOps.this.tester.setFormElement("name", "name");
                TestXsrfSystemOps.this.tester.setFormElement("clazz", "com.atlassian.jira.service.services.export.ExportService");
            }
        }, new XsrfCheck.FormSubmission("Add Service")));
        xsrfChecks.add(new XsrfCheck("Edit Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
                TestXsrfSystemOps.this.tester.clickLink("edit_10000");
            }
        }, new XsrfCheck.FormSubmission("Update")));
        xsrfChecks.add(new XsrfCheck("Delete Service", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfSystemOps.this.navigation.dashboard().navigateTo();
                TestXsrfSystemOps.this.navigation.gotoAdminSection(Navigation.AdminSection.SERVICES);
            }
        }, new XsrfCheck.LinkWithTextSubmission("Delete")));
        new XsrfTestSuite(xsrfChecks).run(this.getTester(), this.navigation, this.form);
    }

    private void gotoHome() {
        this.tester.gotoPage("");
    }
}

