/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.ao;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.SlowTest;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PLUGINS, Category.ACTIVE_OBJECTS, Category.SLOW_IMPORT})
@LoginAs(user="admin")
public class TestActiveObjects
extends BaseJiraFuncTest {
    private static final GenericType<List<Blog>> BLOG_LIST = new GenericType<List<Blog>>(){};
    private Client client;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        ClientConfig config = new ClientConfig();
        config.register(JacksonJsonProvider.class);
        config.register((Object)HttpAuthenticationFeature.basicBuilder().credentials("admin", "admin").build());
        config.register(httpClientBuilder -> {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(20);
            connectionManager.setMaxTotal(100);
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        });
        this.client = ClientBuilder.newClient((Configuration)config);
    }

    @After
    public void tearDownTest() {
        this.client.close();
    }

    @Test
    public void testCreateEntryWithLongId() throws Exception {
        String AUTHOR = "bride";
        String TEXT = "You an I have unfinished business!";
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Blog newBlog = new Blog();
        newBlog.setAuthor("bride");
        newBlog.setText("You an I have unfinished business!");
        newBlog.setComments(Collections.emptyList());
        Response response = (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)newBlog), Response.class);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        List blogs = (List)target.request().get(BLOG_LIST);
        Assert.assertEquals((long)1L, (long)blogs.size());
        Blog savedBlog = (Blog)blogs.get(0);
        Assert.assertEquals((Object)"bride", (Object)savedBlog.author);
        Assert.assertEquals((Object)"You an I have unfinished business!", (Object)savedBlog.text);
        Assert.assertNotNull((Object)savedBlog.id);
    }

    @Test
    public void testUpdateEntryWithLongId() throws Exception {
        String author = "bride";
        String text = "You an I have unfinished business!";
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Blog newBlog = new Blog();
        newBlog.setAuthor(author);
        newBlog.setText(text);
        newBlog.setComments(Collections.emptyList());
        Response response = (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)newBlog), Response.class);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        List blogs = (List)target.request().get(BLOG_LIST);
        Assert.assertEquals((long)1L, (long)blogs.size());
        Blog savedBlog = (Blog)blogs.get(0);
        author = "groom";
        text = "I am leaving on a jet-plane!";
        savedBlog.setAuthor(author);
        savedBlog.setText(text);
        response = (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.json((Object)savedBlog), Response.class);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        blogs = (List)target.request().get(BLOG_LIST);
        Assert.assertEquals((long)1L, (long)blogs.size());
        Blog updatedBlog = (Blog)blogs.get(0);
        Assert.assertEquals((Object)author, (Object)updatedBlog.author);
        Assert.assertEquals((Object)text, (Object)updatedBlog.text);
        Assert.assertEquals((Object)savedBlog.id, (Object)updatedBlog.id);
    }

    @Test
    public void testDelete() throws Exception {
        String author = "bride";
        String text = "You an I have unfinished business!";
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Blog newBlog = new Blog();
        newBlog.setAuthor(author);
        newBlog.setText(text);
        newBlog.setComments(Collections.emptyList());
        Response response = (Response)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)newBlog), Response.class);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)Response.Status.CREATED.getStatusCode()));
        List blogs = (List)target.request().get(BLOG_LIST);
        MatcherAssert.assertThat((Object)blogs.size(), (Matcher)Is.is((Object)1));
        Blog savedBlog = (Blog)blogs.get(0);
        response = (Response)target.path(savedBlog.getId().toString()).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Response.class);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)Response.Status.NO_CONTENT.getStatusCode()));
        blogs = (List)target.request().get(BLOG_LIST);
        MatcherAssert.assertThat((Object)blogs, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    @SlowTest
    public void testCheckAOTablesDeletedOnRestore() throws Exception {
        WebTarget resource = this.createTarget();
        this.deleteAll(resource);
        Blog newBlog = new Blog();
        newBlog.setAuthor("bill");
        newBlog.setText("I'm the man");
        newBlog.setComments(Collections.emptyList());
        Response response = (Response)resource.request(new String[]{"application/json"}).post(Entity.json((Object)newBlog), Response.class);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        this.administration.restoreDataSlowOldWay("blankprojects.xml");
        List blogs = (List)resource.request().get(BLOG_LIST);
        Assert.assertTrue((String)"Blogs should have been cleared on restore.", (boolean)blogs.isEmpty());
    }

    private void deleteAll(WebTarget resource) {
        Response deleteResponse = (Response)resource.request().delete(Response.class);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)deleteResponse.getStatus());
    }

    private WebTarget createTarget() {
        return this.client.target(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("func-test").path("latest").path("blog");
    }

    public static class Comment {
        private Blog blog;
        private String author;
        private String comment;
        private Date date;

        public static Comment build(String author, String comment, Date date) {
            Comment c = new Comment();
            c.author = author;
            c.comment = comment;
            c.date = date;
            return c;
        }

        public Blog getBlog() {
            return this.blog;
        }

        public void setBlog(Blog blog) {
            this.blog = blog;
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Blog {
        private Long id;
        private String author;
        private String text;
        private List<Comment> comments;

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<Comment> getComments() {
            return this.comments;
        }

        public void setComments(List<Comment> comments) {
            this.comments = comments;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

