/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.ao;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PLUGINS, Category.ACTIVE_OBJECTS, Category.REFERENCE_PLUGIN})
@LoginAs(user="admin")
public class TestActiveObjectsTransactions
extends BaseJiraFuncTest {
    private static final GenericType<List<String>> REF_ENTITY_LIST = new GenericType<List<String>>(){};
    private Client client;
    private String ref1 = "Entity 1";
    private String ref2 = "Entity 2";

    @Before
    public void setUpTest() {
        ClientConfig config = new ClientConfig();
        config.register(JacksonJsonProvider.class);
        config.register((Object)HttpAuthenticationFeature.basicBuilder().credentials("admin", "admin").build());
        config.register(httpClientBuilder -> {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(20);
            connectionManager.setMaxTotal(100);
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        });
        this.client = ClientBuilder.newClient((Configuration)config);
    }

    @After
    public void tearDownTest() {
        this.client.close();
    }

    @Test
    public void testAdd() throws Exception {
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Response response = (Response)target.queryParam("description", new Object[]{this.ref1}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), Response.class);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        List refs = (List)target.request().get(REF_ENTITY_LIST);
        MatcherAssert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)refs, (Matcher)Matchers.contains((Object[])new String[]{this.ref1}));
    }

    @Test
    public void testAddInTransaction() throws Exception {
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Response response = (Response)target.path("withTransaction").queryParam("description", new Object[]{this.ref1}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), Response.class);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        List refs = (List)target.request().get(REF_ENTITY_LIST);
        MatcherAssert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)refs, (Matcher)Matchers.contains((Object[])new String[]{this.ref1}));
    }

    @Test
    public void testAddInExternalTransaction() throws Exception {
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Response response = (Response)target.path("withExternalTransaction").queryParam("description", new Object[]{this.ref1}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), Response.class);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        List refs = (List)target.request().get(REF_ENTITY_LIST);
        MatcherAssert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)refs, (Matcher)Matchers.contains((Object[])new String[]{this.ref1}));
        this.deleteAll(target);
        response = (Response)target.path("withExternalTransaction").queryParam("description", new Object[]{this.ref1}).queryParam("description2", new Object[]{this.ref2}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), Response.class);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
        refs = (List)target.request().get(REF_ENTITY_LIST);
        MatcherAssert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)refs, (Matcher)Matchers.contains((Object[])new String[]{this.ref1, this.ref2}));
    }

    @Test
    public void testRollbackExternal() throws Exception {
        WebTarget target = this.createTarget();
        this.deleteAll(target);
        Response response = (Response)target.path("butRollbackExternal").queryParam("description", new Object[]{this.ref1}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(null), Response.class);
        Assert.assertEquals((long)Response.Status.NOT_MODIFIED.getStatusCode(), (long)response.getStatus());
        List refs = (List)target.request().get(REF_ENTITY_LIST);
        Assert.assertEquals((long)0L, (long)refs.size());
    }

    private void deleteAll(WebTarget resource) {
        Response deleteResponse = (Response)resource.request().delete(Response.class);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)deleteResponse.getStatus());
    }

    private WebTarget createTarget() {
        return this.client.target(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("reference-plugin").path("latest").path("refentity");
    }
}

