/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.application;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankDataCenterInstance;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.RestoreBlankServerInstance;
import com.atlassian.jira.functest.framework.backdoor.SalLicenseControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestApplicationConfiguration
extends BaseJiraRestTest {
    private SalLicenseControl salLicenseControl;

    @Before
    public void setUpTest() {
        this.backdoor.darkFeatures().enableForSite("com.atlassian.jira.config.CoreFeatures.LICENSE_ROLES_ENABLED");
        this.salLicenseControl = new SalLicenseControl(this.environmentData);
    }

    @Test
    @RestoreBlankInstance
    public void testThatAdminGetsAddedToTheDefaultGroupOfTheLicense() {
        UserClient userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        MatcherAssert.assertThat((Object)this.backdoor.applicationRoles().getRoles().stream().anyMatch(role -> role.getKey().equals("jira-servicedesk")), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.salLicenseControl.addProductLicense("jira-servicedesk", LicenseKeys.MULTI_ROLE_DC.getLicenseString()), (Matcher)Matchers.is((Object)true));
        List<String> serviceDeskDefaultGroups = this.backdoor.applicationRoles().getRole("jira-servicedesk").getDefaultGroups();
        List<String> testAppDefaultGroups = this.backdoor.applicationRoles().getRole("jira-func-test").getDefaultGroups();
        MatcherAssert.assertThat(serviceDeskDefaultGroups, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        MatcherAssert.assertThat(testAppDefaultGroups, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        List userGroups = userClient.get((String)"admin", (User.Expand[])new User.Expand[]{User.Expand.groups}).groups.items.stream().map(Group::getName).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)userGroups.containsAll(serviceDeskDefaultGroups), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)userGroups.containsAll(testAppDefaultGroups), (Matcher)Matchers.is((Object)true));
        this.assertPermissionsConfigured(serviceDeskDefaultGroups);
        this.assertPermissionsConfigured(testAppDefaultGroups);
    }

    @Test
    @RestoreBlankInstance
    public void testThatConfigurationFailsWhenGroupExist() {
        String groupName = String.format("%s-users", "jira-servicedesk");
        this.backdoor.usersAndGroups().deleteGroup(groupName);
        SalLicenseControl.ValidationResultTO validationResultTO = this.salLicenseControl.validateLicenseString("jira-servicedesk", LicenseKeys.MULTI_ROLE_DC.getLicenseString(), Locale.ENGLISH);
        MatcherAssert.assertThat((Object)validationResultTO.getWarningMessages().isEmpty(), (Matcher)Matchers.is((Object)true));
        this.backdoor.usersAndGroups().addGroup(groupName);
        validationResultTO = this.salLicenseControl.validateLicenseString("jira-servicedesk", LicenseKeys.MULTI_ROLE_DC.getLicenseString(), Locale.ENGLISH);
        MatcherAssert.assertThat((Object)validationResultTO.hasWarnings(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)validationResultTO.hasErrors(), (Matcher)Matchers.is((Object)false));
        this.backdoor.usersAndGroups().deleteGroup(groupName);
    }

    @Test
    @RestoreBlankDataCenterInstance
    public void testThatExistingConfigurationIsPreservedDC() {
        String myGroup = "my-group";
        this.backdoor.usersAndGroups().addGroup("my-group");
        MatcherAssert.assertThat((Object)this.salLicenseControl.addProductLicense("jira-func-test", LicenseKeys.TEST_ROLE_DC.getLicenseString()), (Matcher)Matchers.is((Object)true));
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-func-test", Sets.newHashSet((Object[])new String[]{"my-group"}), Sets.newHashSet((Object[])new String[]{"my-group"}));
        this.salLicenseControl.deleteProductLicense("jira-func-test");
        MatcherAssert.assertThat((Object)this.salLicenseControl.addProductLicense("jira-func-test", LicenseKeys.TEST_ROLE_DC.getLicenseString()), (Matcher)Matchers.is((Object)true));
        List<String> testAppDefaultGroups = this.backdoor.applicationRoles().getRole("jira-func-test").getDefaultGroups();
        MatcherAssert.assertThat(testAppDefaultGroups, (Matcher)Matchers.contains((Matcher)Matchers.is((Object)"my-group")));
    }

    @Test
    @RestoreBlankServerInstance
    public void testThatExistingConfigurationIsPreservedServer() {
        String myGroup = "my-group";
        this.backdoor.usersAndGroups().addGroup("my-group");
        MatcherAssert.assertThat((Object)this.salLicenseControl.addProductLicense("jira-func-test", LicenseKeys.TEST_ROLE.getLicenseString()), (Matcher)Matchers.is((Object)true));
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-func-test", Sets.newHashSet((Object[])new String[]{"my-group"}), Sets.newHashSet((Object[])new String[]{"my-group"}));
        this.salLicenseControl.deleteProductLicense("jira-func-test");
        MatcherAssert.assertThat((Object)this.salLicenseControl.addProductLicense("jira-func-test", LicenseKeys.TEST_ROLE.getLicenseString()), (Matcher)Matchers.is((Object)true));
        List<String> testAppDefaultGroups = this.backdoor.applicationRoles().getRole("jira-func-test").getDefaultGroups();
        MatcherAssert.assertThat(testAppDefaultGroups, (Matcher)Matchers.contains((Matcher)Matchers.is((Object)"my-group")));
    }

    private void assertPermissionsConfigured(List<String> groups) {
        for (GlobalPermissionKey gpKey : GlobalPermissionKey.DEFAULT_APP_GLOBAL_PERMISSIONS) {
            MatcherAssert.assertThat((Object)this.groupFor(gpKey).containsAll(groups), (Matcher)Matchers.is((Object)true));
        }
    }

    private List<String> groupFor(GlobalPermissionKey permKey) {
        return this.backdoor.permissions().getGlobalPermissionGroups(((Integer)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.inverse().get((Object)permKey)).intValue());
    }
}

