/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.BROWSING})
@LoginAs(user="admin")
public class TestEditAttachmentSettingsCustomPath
extends BaseJiraFuncTest {
    private static final String FALSE = "false";
    private static final String EDIT_SETTINGS_TEXT = "Edit Settings";
    private static final String CUSTOM_DIRECTORY_OPTION_LABEL = "Use custom directory";
    private static final String ATTACHMENTS_ENABLED_CONTROL_NAME = "attachmentsEnabled";
    private static final String SAVE_BUTTON_LABEL = "Save";
    @Inject
    private Administration administration;
    @Rule
    public TemporaryFolder attachmentPath = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        Assume.assumeTrue((boolean)this.backdoor.attachmentFile().isInSharedHome());
        this.administration.restoreDataWithReplacedTokens("TestEditAttachmentSettingsCustomPath.xml", (Map<String, String>)ImmutableMap.of((Object)"@ATTACHMENT_DIR@", (Object)this.attachmentPath.getRoot().getAbsolutePath()));
    }

    @Test
    public void testDisableAttachmentsClearsCustomPathWhenAttachmentsAreInSharedHome() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText(EDIT_SETTINGS_TEXT);
        this.tester.assertTextPresent(CUSTOM_DIRECTORY_OPTION_LABEL);
        this.tester.checkCheckbox(ATTACHMENTS_ENABLED_CONTROL_NAME, FALSE);
        this.tester.setFormElement("thumbnailsEnabled", FALSE);
        this.tester.setFormElement("zipSupport", FALSE);
        this.tester.submit(SAVE_BUTTON_LABEL);
        this.tester.clickLinkWithText(EDIT_SETTINGS_TEXT);
        this.tester.checkCheckbox(ATTACHMENTS_ENABLED_CONTROL_NAME, "true");
        this.tester.submit(SAVE_BUTTON_LABEL);
        this.tester.assertTextPresent("<strong>Jira home</strong>");
        this.tester.clickLinkWithText(EDIT_SETTINGS_TEXT);
        this.tester.assertTextNotPresent(CUSTOM_DIRECTORY_OPTION_LABEL);
    }

    @Test
    public void testDisableCustomPathClearsCustomPath() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText(EDIT_SETTINGS_TEXT);
        this.tester.assertTextPresent(CUSTOM_DIRECTORY_OPTION_LABEL);
        this.tester.checkCheckbox("customAttachmentPathSelectedInUi", FALSE);
        this.tester.submit(SAVE_BUTTON_LABEL);
        this.tester.assertTextPresent("<strong>Jira home</strong>");
        this.tester.clickLinkWithText(EDIT_SETTINGS_TEXT);
        this.tester.assertTextNotPresent(CUSTOM_DIRECTORY_OPTION_LABEL);
    }

    @Test
    public void testEditAttachmentSettingsWithGlobalAdmin() {
        this.navigation.logout();
        this.navigation.login("globaladmin", "globaladmin");
        this.navigation.gotoAdmin();
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText(EDIT_SETTINGS_TEXT);
        this.tester.assertFormElementNotPresent(ATTACHMENTS_ENABLED_CONTROL_NAME);
        this.tester.assertFormElementNotPresent("customAttachmentPathSelectedInUi");
    }
}

