/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.avatar;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;

public class ImageClient {
    public Image get(String url) {
        try {
            HttpURLConnection con = (HttpURLConnection)UriBuilder.fromUri((String)url).build(new Object[0]).toURL().openConnection();
            String contentType = con.getContentType();
            byte[] bytes = IOUtils.toByteArray((InputStream)con.getInputStream(), (int)con.getContentLength());
            return Image.create(contentType, bytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(url, ex);
        }
    }

    public static final class Image {
        private Type type;
        private byte[] bytes;

        private static Image create(String contentType, byte[] bytes) {
            Type type = Arrays.asList(Type.values()).stream().filter(imgType -> contentType.contains(((Type)imgType).contentType)).findFirst().get();
            return new Image(type, bytes);
        }

        public Image(Type type, byte[] bytes) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            this.bytes = bytes;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public List<Byte> getBytesList() {
            return Bytes.asList((byte[])this.bytes);
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Image that = (Image)o;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.bytes, (Object)that.bytes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.bytes});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("bytes", (Object)this.bytes).toString();
        }

        public static enum Type {
            SVG("svg"),
            PNG("png"),
            OTHER("");

            private final String contentType;

            private Type(String contentType) {
                this.contentType = contentType;
            }
        }
    }
}

