/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.avatar;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.avatar.ImageClient;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
@RestoreOnce(value="blankprojects.xml")
public class TestGettingIconsAsPNGs
extends BaseJiraFuncTest {
    private static final String ISSUE_TYPE = "/secure/viewavatar?avatarId=10243&avatarType=issuetype";
    private static final String PROJECT_AVATAR = "/secure/projectavatar?pid=10000&avatarId=10001";
    private static final String PRIORITY = "/images/icons/priorities/major.svg";
    private final ImageClient imageClient = new ImageClient();

    @Test
    public void svgIsReturnedWhenNoQueryParamIsAdded() {
        this.testSvgIsReturned(ISSUE_TYPE);
        this.testSvgIsReturned(PROJECT_AVATAR);
        this.testSvgIsReturned(PRIORITY);
    }

    private void testSvgIsReturned(String relativeUrl) {
        ImageClient.Image image = this.imageClient.get(this.prependBaseUrl(relativeUrl));
        Assert.assertThat((Object)((Object)image.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.SVG)));
        Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void avatarIsReturnedAsPngIfFormatIsSetToPng() {
        String url = this.prependBaseUrl(PROJECT_AVATAR) + "&format=PNG";
        ImageClient.Image image = this.imageClient.get(url);
        Assert.assertThat((Object)((Object)image.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void avatarIsReturnedAsPngIfFormatIsSetToPngInLowerCase() {
        String url = this.prependBaseUrl(PROJECT_AVATAR) + "&format=png";
        ImageClient.Image image = this.imageClient.get(url);
        Assert.assertThat((Object)((Object)image.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void avatarIsReturnedAsPngIfFormatIsSetToPngInDifferentCase() {
        String url = this.prependBaseUrl(PROJECT_AVATAR) + "&format=PnG";
        ImageClient.Image image = this.imageClient.get(url);
        Assert.assertThat((Object)((Object)image.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void issueTypeIsReturnedAsPngIfFormatIsSetToPng() {
        String url = this.prependBaseUrl(ISSUE_TYPE) + "&format=PNG";
        ImageClient.Image image = this.imageClient.get(url);
        Assert.assertThat((Object)((Object)image.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void priorityIsReturnedAsPngIfFormatIsSetToPng() {
        String url = this.prependBaseUrl(PRIORITY) + "?format=PNG";
        ImageClient.Image image = this.imageClient.get(url);
        Assert.assertThat((Object)((Object)image.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void pngImagesCanBeReturnedTwice() {
        this.testReturningTwice("/secure/viewavatar?avatarId=10243&avatarType=issuetype&format=PNG");
        this.testReturningTwice("/secure/projectavatar?pid=10000&avatarId=10001&format=PNG");
        this.testReturningTwice("/images/icons/priorities/major.svg?format=PNG");
    }

    @Test
    public void pngImagesCanBeReturnedInDifferentSizes() {
        this.testDifferentSizedOfPngImages("/secure/viewavatar?avatarId=10243&avatarType=issuetype&format=PNG");
        this.testDifferentSizedOfPngImages("/secure/projectavatar?pid=10000&avatarId=10001&format=PNG");
        this.testDifferentSizedOfPngImages("/images/icons/priorities/major.svg?format=PNG");
    }

    private void testReturningTwice(String url) {
        ImageClient.Image first = this.imageClient.get(this.prependBaseUrl(url));
        Assert.assertThat((Object)((Object)first.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(first.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        ImageClient.Image second = this.imageClient.get(this.prependBaseUrl(url));
        Assert.assertThat((Object)((Object)second.getType()), (Matcher)Matchers.equalTo((Object)((Object)ImageClient.Image.Type.PNG)));
        Assert.assertThat(second.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    private void testDifferentSizedOfPngImages(String urlToPngImage) {
        int previousLength = 0;
        for (Avatar.Size size : Ordering.natural().onResultOf(Avatar.Size::getPixels).sortedCopy(Arrays.asList(Avatar.Size.values()))) {
            ImageClient.Image image = this.imageClient.get(this.prependBaseUrl(urlToPngImage) + "&size=" + size.getParam());
            Assert.assertThat(image.getBytesList(), (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(previousLength))));
            previousLength = image.getBytes().length;
        }
    }

    private String prependBaseUrl(String relativeUrl) {
        return this.environmentData.getBaseUrl().toString() + relativeUrl;
    }
}

