/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jsoup.Jsoup;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestBulkChangeSetup.xml")
public class TestBulkEditIssues
extends BaseJiraFuncTest {
    private static final String HSP_5 = "HSP-5";
    private static final String TST_1 = "TST-1";
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String UNAVAILABLE_BULK_EDIT_ACTIONS_TABLE_ID = "unavailableActionsTable";
    private static final String SESSION_TIMEOUT_MESSAGE_CONTAINER_LOCATOR = ".aui-message.aui-message-warning";
    private static final String OPTION_UNASSIGNED = "Unassigned";
    @Inject
    private Indexing indexing;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @After
    public void tearDown() {
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    public void testBulkEditOneIssueInCurrentPage() {
        this.logger.log((Object)"Bulk Change - Edit Operation: ONE issue from CURRENT page");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String summary = "EditOneIssueInCurrentPage";
        this.addCurrentPageLink();
        String key = this.addIssue("EditOneIssueInCurrentPage");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)key), (Map<String, String>)ImmutableMap.of((Object)"fixVersion", (Object)"New Version 1", (Object)"version", (Object)"New Version 2"), key);
        this.navigation.issueNavigator().createSearch("");
        this.bulkOperations.bulkChangeIncludeCurrentPage();
        this.bulkOperations.bulkChangeSelectIssue(key);
        this.bulkOperations.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Major");
        this.bulkOperations.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Major");
        this.bulkOperations.bulkEditConfirmEdit(fields);
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/issues/?jql=");
    }

    @Test
    public void testBulkEditOneIssueInAllPages() {
        this.logger.log((Object)"Bulk Change - Edit Operation: ONE issue from ALL pages");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String summary = "EditOneIssueInAllPages";
        this.addCurrentPageLink();
        String key = this.addIssue("EditOneIssueInAllPages");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssue(key);
        this.bulkOperations.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 1");
        fields.put("components", "New Component 1");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkOperations.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("fixVersions", "New Version 1");
        fields.put("versions", "New Version 1");
        fields.put("components", "New Component 1");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkOperations.bulkEditConfirmEdit(fields);
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/issues/?jql=");
    }

    @Test
    public void testBulkEditAllIssuesInCurrentPage() {
        this.logger.log((Object)"Bulk Change - Edit Operation: ALL issue from CURRENT pages");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        this.addCurrentPageLink();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeCurrentPage();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fixVersions", "New Version 2");
        fields.put("versions", "New Version 2");
        fields.put("components", "New Component 1");
        fields.put("assignee", OPTION_UNASSIGNED);
        this.bulkOperations.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("fixVersions", "New Version 2");
        fields.put("versions", "New Version 2");
        fields.put("components", "New Component 1");
        fields.put("assignee", OPTION_UNASSIGNED);
        this.bulkOperations.bulkEditConfirmEdit(fields);
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/issues/?jql=");
        this.bulkOperations.deleteAllIssuesInAllPages();
        this.administration.generalConfiguration().setAllowUnassignedIssues(false);
    }

    @Test
    public void testBulkEditAllIssuesInAllPages() {
        this.logger.log((Object)"Bulk Change - Edit Operation: ALL issue from ALL pages");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.addCurrentPageLink();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.bulkChangeChooseOperationEdit();
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkOperations.bulkEditOperationDetailsSetAs(fields);
        fields = new HashMap();
        fields.put("versions", "New Version 2");
        fields.put("assignee", "Administrator");
        fields.put("priority", "Blocker");
        this.bulkOperations.bulkEditConfirmEdit(fields);
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("/issues/?jql=");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Blocker"), null, "HSP-1");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Blocker"), null, HSP_5);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"version", (Object)"New Version 2", (Object)"assignee", (Object)"Administrator", (Object)"priority", (Object)"Blocker"), null, "HSP-9");
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditIssuesIssueTypesWithDiffWorkflows() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssue(HSP_5);
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Test Bug", "Test Improvment", "Test New Feature"});
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditIssuesIssueTypesWithDiffWorkflowsMultipleIssues() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssues(Arrays.asList("HSP-2", TST_1));
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Task"});
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditIssuesIssueTypesWithDifferentWorkflowsNoOptions() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssues(Arrays.asList(HSP_5, TST_1));
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.textAssertions.assertTextPresent(this.locator.id(UNAVAILABLE_BULK_EDIT_ACTIONS_TABLE_ID), "There are no issue types available for selected issues.");
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditIssuesIssueTypesWithDifferentFieldConfigurationSchemes() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssue("TST-3");
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Improvement"});
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditIssuesIssueTypesWithDifferentWorkflowsSubtasks() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssue("HSP-6");
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Super Sub-taks"});
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditIssuesIssueTypesWithDiffFieldConfSchemesSubtasks() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssue("TST-4");
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.assertions.getProjectFieldsAssertions().assertIssueTypesEquals(new String[]{"Sub-task"});
    }

    @Test
    @Restore(value="blankprojects.xml")
    public void testBulkEditSessionTimeouts() {
        this.logger.log((Object)"Bulk Edit - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.tester.beginAt("secure/views/bulkedit/BulkEditDetails.jspa");
        this.verifyAtSessionTimeoutPage();
        String xsrfToken = this.page.getXsrfToken();
        this.tester.beginAt("secure/views/bulkedit/BulkEditDetailsValidation.jspa?atl_token=" + xsrfToken);
        this.verifyAtSessionTimeoutPage();
    }

    private void verifyAtSessionTimeoutPage() {
        this.textAssertions.assertTextPresent(this.locator.css(SESSION_TIMEOUT_MESSAGE_CONTAINER_LOCATOR), "Your session timed out while performing bulk operation on issues.");
    }

    @Test
    @Restore(value="TestBulkEditIssues.xml")
    public void testBulkEditWithCommentVisibility() {
        this.navigation.comment().enableCommentGroupVisibility(Boolean.TRUE);
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssues(Arrays.asList(HSP_5, TST_1));
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", "Minor");
        this.tester.checkCheckbox("actions", "comment");
        this.tester.setFormElement("comment", COMMENT_1);
        this.tester.submit("Next");
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.addComment(COMMENT_2, "jira-developers");
        this.addComment(COMMENT_3, "Developers");
        this.addComment("This comment should be visible to users role.", "Users");
        this.addComment("This comment should be visible to jira-users group", "jira-users");
        this.addComment("this comment should be visible to jira admins", "jira-administrators");
        this.addComment("this comment should be visible to Administrators role", "Administrators");
        ImmutableList userComments = ImmutableList.of((Object)"This comment should be visible to users role.", (Object)"This comment should be visible to jira-users group", (Object)COMMENT_1);
        ImmutableList developerComments = ImmutableList.of((Object)COMMENT_2, (Object)COMMENT_3);
        ImmutableList adminComments = ImmutableList.of((Object)"this comment should be visible to jira admins", (Object)"this comment should be visible to Administrators role");
        this.assertions.comments((Iterable<String>)userComments).areVisibleTo("fred", HSP_5);
        this.assertions.comments((Iterable<String>)userComments).areVisibleTo("fred", TST_1);
        this.assertions.comments(Iterables.concat((Iterable)developerComments, (Iterable)adminComments)).areNotVisibleTo("fred", HSP_5);
        this.assertions.comments(Iterables.concat((Iterable)developerComments, (Iterable)adminComments)).areNotVisibleTo("fred", TST_1);
        this.assertions.comments(Iterables.concat((Iterable)adminComments, (Iterable)userComments)).areVisibleTo("adminman", HSP_5);
        this.assertions.comments(Iterables.concat((Iterable)adminComments, (Iterable)userComments)).areVisibleTo("adminman", TST_1);
        this.assertions.comments((Iterable<String>)developerComments).areNotVisibleTo("adminman", HSP_5);
        this.assertions.comments((Iterable<String>)developerComments).areNotVisibleTo("adminman", TST_1);
        this.assertions.comments(Iterables.concat((Iterable)userComments, (Iterable)developerComments)).areVisibleTo("devman", HSP_5);
        this.assertions.comments(Iterables.concat((Iterable)userComments, (Iterable)developerComments)).areVisibleTo("devman", TST_1);
        this.assertions.comments((Iterable<String>)adminComments).areNotVisibleTo("devman", HSP_5);
        this.assertions.comments((Iterable<String>)adminComments).areNotVisibleTo("devman", TST_1);
        this.assertions.comments(Iterables.concat((Iterable)developerComments, (Iterable)adminComments, (Iterable)userComments)).areVisibleTo("admin", HSP_5);
        this.assertions.comments(Iterables.concat((Iterable)developerComments, (Iterable)adminComments, (Iterable)userComments)).areVisibleTo("admin", TST_1);
    }

    private void addComment(String comment, String commentLevel) {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeSelectIssues(Arrays.asList(HSP_5, TST_1));
        this.bulkOperations.bulkChangeChooseOperationEdit();
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", "Minor");
        this.tester.checkCheckbox("actions", "comment");
        this.tester.setFormElement("comment", comment);
        this.tester.selectOption("commentLevel", commentLevel);
        this.tester.submit("Next");
        this.bulkOperations.bulkChangeConfirm();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
    }

    private String addIssue(String summary) {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", summary, "admin", "Major", "Bug");
        this.backdoor.issues().setIssueFields(issue.key(), new IssueFields().description("description for " + summary).environment("test environment"));
        return issue.key;
    }

    private void addCurrentPageLink() {
        String tableString = this.backdoor.issueTableClient().setSessionSearch("").getIssueTable().getTable();
        while (tableString == null || Jsoup.parse((String)tableString).getElementsByClass("icon-next").size() == 0) {
            this.addIssue("add current page link");
            tableString = this.backdoor.issueTableClient().setSessionSearch("").getIssueTable().getTable();
        }
    }
}

