/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.Rules;
import javax.inject.Inject;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.BULK_OPERATIONS})
@LoginAs(user="admin")
@Restore(value="TestAttachmentEncoding.xml")
public class TestBulkMoveAttachments
extends BaseJiraFuncTest {
    @Rule
    public TestRule copyAttachmentsRule = Rules.prepareAttachments(this::getEnvironmentData, this::getBackdoor, "TestAttachmentEncoding/attachments");
    @Inject
    private BulkOperations bulkOperations;

    @Test
    public void testBulkMove() throws Exception {
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    @Test
    public void testBulkMoveFromRenamedProject() throws Exception {
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("HSP"), "OTHER");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    @Test
    public void testBulkMoveToRenamedProject() throws Exception {
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("MKY"), "OTHER");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("OTHER-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }

    @Test
    public void testBulkMoveFromRenamedToRenamedProject() throws Exception {
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("HSP"), "HASP");
        this.backdoor.project().editProjectKey(this.backdoor.project().getProjectId("MKY"), "MONKEY");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MONKEY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }
}

