/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
@LoginAs(user="admin")
public class TestBulkMoveIssuesForEnterprise
extends BaseJiraFuncTest {
    private static final String CONFIRMATION_TEXT = "Please confirm that the correct changes have been entered.";
    private static final String BULK_EDIT_KEY = "10000_1_";
    private static final String TARGET_PROJECT_ID = "10000_1_pid";
    private static final String TARGET_ISSUE_TYPE_ID = "10000_1_issuetype";
    private static final String STD_ISSUE_SELECTION = "Select Projects and Issue Types";
    private static final String ENT_UPDATE_FIELDS_PROJECT = "Update Fields for Target Project '";
    private static final String ENT_UPDATE_FIELDS_ISSUE_TYPE = "' - Issue Type '";
    private static final String ENT_UPDATE_FIELDS_END = "'";
    private static final String FIELDS_UPDATE_AUTO = "All field values will be retained";
    @Inject
    private Indexing indexing;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="TestBulkMoveAssigneeChange.xml")
    public void testBulkMoveChangeAssignee() throws Exception {
        this.startBulkMoveForIssue(10000L);
        this.setTargetProject("Source");
        this.assertRetainAssignees();
        this.tester.submit("Next");
        this.assertConfirmationScreen();
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue("SRC-5");
        this.assertions.getViewIssueAssertions().assertAssignee("Source User");
    }

    @Test
    @Restore(value="TestBulkMoveSubTasks.xml")
    public void testBulkMoveSubTasks() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"RAT-4", "No more milk", "Level Mouse"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"RAT-3", "Get new milk bucket", "Level Mouse"});
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Improvement", "Rattus"});
        this.navigation.issue().selectProject("Bovine", "10022_4_pid");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Sub-task", "Rattus"});
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Improvement", "Rattus"});
        this.tester.assertTextPresent("Security Level");
        this.tester.assertFormElementPresent("security");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Sub-task", "Rattus"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "The security level of subtasks is inherited from parents."});
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 4 of 4: Confirmation");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.assertTextNotPresent("RAT-4");
        this.tester.assertTextNotPresent("RAT-3");
        this.tester.assertTextNotPresent("Level Mouse");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"COW-35", "No more milk"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"COW-34", "Get new milk bucket"});
    }

    @Test
    @Restore(value="TestBulkMoveIssuesForEnterprise.xml")
    public void testMoveSessionTimeouts() {
        this.logger.log((Object)"Bulk Move - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.tester.beginAt("secure/views/bulkedit/BulkMigrateDetails.jspa");
        this.verifyAtSessionTimeoutPage();
        this.tester.beginAt("secure/views/bulkedit/BulkMigrateChooseSubTaskContext!default.jspa?subTaskPhase=false");
        this.verifyAtSessionTimeoutPage();
        this.tester.beginAt("secure/views/bulkedit/BulkMigrateSetFields!default.jspa?subTaskPhase=false");
        this.verifyAtSessionTimeoutPage();
        this.tester.beginAt("secure/views/bulkedit/BulkMigrateSetFields!default.jspa?subTaskPhase=true");
        this.verifyAtSessionTimeoutPage();
        this.tester.beginAt("secure/views/bulkedit/BulkMigrateSetFields.jspa");
        this.verifyAtSessionTimeoutPage();
    }

    private void verifyAtSessionTimeoutPage() {
        this.tester.assertTextPresent("Your session timed out while performing bulk operation on issues.");
    }

    @Test
    @Restore(value="blankprojects.xml")
    public void testMoveIssueTypeWithAndWithoutSubtasks() {
        this.logger.log((Object)"Bulk Move - Move multiple issue types where at least one (but not all) issue types do not have sub tasks");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        String issueKey1 = this.backdoor.issues().createIssue("MKY", "issueKey1", null, "Major", "1").key();
        String issueKey2 = this.backdoor.issues().createIssue("MKY", "issueKey2", null, "Major", "4").key();
        String subTaskKey1 = this.navigation.issue().createSubTask(issueKey1, "Sub-task", "subtask1", "");
        this.editIssueFieldVisibility.resetFields();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.tester.assertTextPresent(STD_ISSUE_SELECTION);
        this.navigation.issue().selectProject("homosapien", "10001_1_pid");
        this.navigation.issue().selectIssueType("Bug", "10001_1_issuetype");
        this.navigation.issue().selectProject("homosapien", "10001_4_pid");
        this.navigation.issue().selectIssueType("Improvement", "10001_4_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'homosapien' - Issue Type 'Bug'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'homosapien' - Issue Type 'Sub-task'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'homosapien' - Issue Type 'Improvement'");
        this.tester.submit("Next");
        this.bulkOperations.isStepConfirmation();
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(issueKey1);
        this.tester.assertLinkPresentWithText("homosapien");
        this.tester.assertLinkNotPresentWithText("monkey");
        this.navigation.issue().gotoIssue(issueKey2);
        this.tester.assertLinkPresentWithText("homosapien");
        this.tester.assertLinkNotPresentWithText("monkey");
        this.navigation.issue().gotoIssue(subTaskKey1);
        this.tester.assertLinkPresentWithText("homosapien");
        this.tester.assertLinkNotPresentWithText("monkey");
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    @Restore(value="TestBulkMoveIssuesForEnterprise.xml")
    public void testBulkMoveParentIssuesProjectAndIssueType() {
        this.logger.log((Object)"Bulk Move - Test bulk move Parent issues - Move the parents Project and Issue type");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String issueKey1 = "NDT-1";
        String issueId1 = "10000";
        String issueKey2 = "HSP-1";
        String issueId2 = "10001";
        String issueKey3 = "HSP-2";
        String issueId3 = "10002";
        String issueKey4 = "NDT-2";
        String issueId4 = "10003";
        String issueKey5 = "MKY-1";
        String issueId5 = "10004";
        this.backdoor.subtask().enable();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.isStepChooseIssues();
        this.tester.checkCheckbox("bulkedit_10000");
        this.tester.checkCheckbox("bulkedit_10001");
        this.tester.assertCheckboxNotSelected("bulkedit_10002");
        this.tester.assertCheckboxNotSelected("bulkedit_10003");
        this.tester.checkCheckbox("bulkedit_10004");
        this.tester.submit("Next");
        this.bulkOperations.chooseOperationBulkMove();
        this.tester.assertTextPresent("Target Project");
        this.tester.checkCheckbox("sameAsBulkEditBean", BULK_EDIT_KEY);
        this.navigation.issue().selectProject("homosapien", TARGET_PROJECT_ID);
        this.navigation.issue().selectIssueType("Improvement", TARGET_ISSUE_TYPE_ID);
        this.tester.submit("Next");
        this.tester.assertTextPresent(FIELDS_UPDATE_AUTO);
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertions.assertLastChangeHistoryRecords("NDT-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Project", "neanderthal", "homosapien"), new ExpectedChangeHistoryItem("Issue Type", "New Feature", "Improvement"), new ExpectedChangeHistoryItem("Key", "NDT-1", "HSP")));
        this.assertions.assertLastChangeHistoryRecords("MKY-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Project", "monkey", "homosapien"), new ExpectedChangeHistoryItem("Key", "MKY-1", "HSP")));
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Issue Type", "Bug", "Improvement")));
        this.assertions.assertLastChangeHistoryRecords("HSP-2", Collections.emptyList());
        this.assertions.assertLastChangeHistoryRecords("NDT-2", Collections.emptyList());
    }

    @Test
    @Restore(value="TestBulkMoveIssuesForEnterprise.xml")
    public void testBulkMoveSubTaskAndItsParentSelectParents() {
        this.logger.log((Object)"Bulk Move - Test bulk move subtask and its parent - Move the parents Project and Issue type");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String issueKey1 = "NDT-3";
        String issueId1 = "10010";
        String subTaskKey1 = "NDT-4";
        String subTaskId1 = "10011";
        String subTaskKey2 = "NDT-5";
        String subTaskId2 = "10012";
        String issueKey2 = "HSP-3";
        String issueId2 = "10013";
        String issueKey3 = "HSP-4";
        String issueId3 = "10014";
        String subTaskKey3 = "HSP-5";
        String subTaskId3 = "10015";
        String issueKey4 = "NDT-6";
        String issueId4 = "10016";
        this.backdoor.subtask().enable();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.isStepChooseIssues();
        this.tester.checkCheckbox("bulkedit_10010");
        this.tester.checkCheckbox("bulkedit_10011");
        this.tester.checkCheckbox("bulkedit_10012");
        this.tester.checkCheckbox("bulkedit_10013");
        this.tester.assertCheckboxNotSelected("bulkedit_10014");
        this.tester.assertCheckboxNotSelected("bulkedit_10015");
        this.tester.assertCheckboxNotSelected("bulkedit_10016");
        this.tester.submit("Next");
        this.bulkOperations.chooseOperationBulkMove();
        this.tester.assertTextPresent("Target Project");
        this.tester.checkCheckbox("sameAsBulkEditBean", BULK_EDIT_KEY);
        this.navigation.issue().selectProject("homosapien", TARGET_PROJECT_ID);
        this.navigation.issue().selectIssueType("Improvement", TARGET_ISSUE_TYPE_ID);
        this.tester.submit("Next");
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.navigation.issue().selectIssueType("Sub-task", "10001_5_10000_10010_issuetype");
        this.tester.submit("Next");
        this.tester.assertTextPresent(FIELDS_UPDATE_AUTO);
        this.tester.submit("Next");
        this.tester.assertTextPresent(FIELDS_UPDATE_AUTO);
        this.tester.submit("Next");
        this.tester.assertTextPresent(CONFIRMATION_TEXT);
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertions.assertLastChangeHistoryRecords("NDT-3", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Project", "neanderthal", "homosapien"), new ExpectedChangeHistoryItem("Issue Type", "New Feature", "Improvement"), new ExpectedChangeHistoryItem("Key", "NDT-3", "HSP")));
        this.assertions.assertLastChangeHistoryRecords("NDT-4", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Project", "neanderthal", "homosapien"), new ExpectedChangeHistoryItem("Key", "NDT-4", "HSP")));
        this.assertions.assertLastChangeHistoryRecords("NDT-5", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Project", "neanderthal", "homosapien"), new ExpectedChangeHistoryItem("Key", "NDT-5", "HSP")));
        this.assertions.assertLastChangeHistoryRecords("HSP-3", new ExpectedChangeHistoryRecord(new ExpectedChangeHistoryItem("Issue Type", "Bug", "Improvement")));
        this.assertions.assertLastChangeHistoryRecords("HSP-4", Collections.emptyList());
        this.assertions.assertLastChangeHistoryRecords("HSP-5", Collections.emptyList());
        this.assertions.assertLastChangeHistoryRecords("NDT-6", Collections.emptyList());
        this.backdoor.subtask().disable();
    }

    @Test
    @Restore(value="TestBulkMoveIssuesForEnterpriseIssueLevelSecurity.xml")
    public void testBulkMoveIssuesWithSecurityLevels() {
        String issueKey1 = this.backdoor.issues().createIssue("HSP", "Summary for Bug", null, "Major", "Bug").key();
        String issueKey2 = this.backdoor.issues().createIssue("HSP", "Summary for New Feature", null, "Major", "New Feature").key();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.tester.assertTextPresent(STD_ISSUE_SELECTION);
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.navigation.issue().selectProject("monkey", "10000_2_pid");
        this.tester.submit("Next");
        this.tester.selectOption("security", "Medium");
        this.tester.submit("Next");
        this.tester.selectOption("security", "High");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Medium");
        this.tester.assertTextPresent("High");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(issueKey1);
        this.tester.assertTextPresent("Medium");
        this.navigation.issue().gotoIssue(issueKey2);
        this.tester.assertTextPresent("High");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"MKY-6", (Object)"security", (Object)"Medium"), null, "MKY-6");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"MKY-7", (Object)"security", (Object)"High"), null, "MKY-7");
    }

    @Test
    @Restore(value="TestBulkMoveIssuesForEnterpriseCustomFieldContextBehaviour.xml")
    public void testBulkMoveWithCustomFieldContextBehaviour() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10011", "on");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("homosapien", "10001_1_pid");
        this.tester.submit("Next");
        this.navigation.issue().selectIssueType("Sub-task", "10001_5_10000_10000_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Man Bug Custom Field");
        this.tester.selectOption("customfield_10002", "Yes");
        this.tester.submit("Next");
        this.tester.assertTextPresent(FIELDS_UPDATE_AUTO);
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("Another Monkey Bug!");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10001"), "Monkey Option");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10002"), "Yes");
    }

    @Test
    @Restore(value="TestBulkMoveRetainWarningTest.xml")
    public void testBulkMoveRetainWarning() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.bulkOperations.chooseOperationBulkMove();
        this.tester.assertTextPresent(STD_ISSUE_SELECTION);
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.tester.submit("Next");
        this.tester.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Fix Version/s</strong>");
        this.tester.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Affects Version/s</strong>");
        this.tester.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Component/s</strong>");
        this.tester.assertTextNotPresent("Issues not in the project <strong>monkey</strong> will not retain values for <strong>Description</strong>");
    }

    @Test
    @Restore(value="TestBulkMoveMapWorkflows.xml")
    public void testBulkMoveAndChangeStatus() {
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"HSP-13", (Object)"type", (Object)"Bug", (Object)"status", (Object)"Totally Open", (Object)"summary", (Object)"bugs3"), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"MKY-13"), "HSP-13");
        this.navigation.issueNavigator().createSearch("project=homosapien");
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.checkAllIssuesOnPage();
        this.moveIssuesToMonkey();
        this.assertStatusMapped("MKY-11");
        String movedIssueKey = this.backdoor.issueNavControl().getIssueKeyForSummary("bugs3");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)movedIssueKey, (Object)"type", (Object)"Bug", (Object)"status", (Object)"Open", (Object)"summary", (Object)"bugs3"), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)"HSP-14"), movedIssueKey);
    }

    private void assertStatusMapped(String issue) {
        this.navigation.issue().gotoIssue(issue);
        this.tester.assertTextPresent("Open");
        this.tester.assertTextNotPresent("Totally Open");
    }

    private void moveIssuesToMonkey() {
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("monkey", TARGET_PROJECT_ID);
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
    }

    private void checkAllIssuesOnPage() {
        this.tester.checkCheckbox("bulkedit_10022", "on");
        this.tester.checkCheckbox("bulkedit_10023", "on");
        this.tester.checkCheckbox("bulkedit_10024", "on");
        this.tester.checkCheckbox("bulkedit_10025", "on");
    }

    private void startBulkMoveForIssue(long id) {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Bulk Operation", "Choose Issues"});
        this.tester.checkCheckbox("bulkedit_" + id, "on");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Bulk Operation", "Choose Operation"});
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
    }

    private void setTargetProject(String option) {
        this.assertSelectProjectScreen();
        this.navigation.issue().selectProject(option, "10010_1_pid");
        this.tester.submit("Next");
    }

    private void assertConfirmationScreen() {
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Move Issues", "Confirmation"});
    }

    private void assertSelectProjectScreen() {
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Move Issues", STD_ISSUE_SELECTION});
    }

    private void assertRetainAssignees() {
        this.tester.assertTextPresent(FIELDS_UPDATE_AUTO);
    }
}

