/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
@Restore(value="IssuesWithSubTasksWorkflowScheme.xml")
@LoginAs(user="admin")
public class TestBulkMoveWithMultiContexts
extends BaseJiraFuncTest {
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testBulkMoveWithMultiContexts() throws Exception {
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.navigation.clickOnNext();
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("Select Projects and Issue Types");
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.tester.assertTextPresent("Super Sub Task");
        this.tester.assertTextPresent("Mega Sub Task");
        this.navigation.issue().selectIssueType("Sub-task", "10000_6_10001_10000_issuetype");
        this.navigation.issue().selectIssueType("Sub-task", "10000_7_10001_10000_issuetype");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("Map Status for Target Project 'monkey' - Issue Type 'Bug'");
        this.tester.selectOption("10000", "Open");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("All field values will be retained");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("Map Status for Target Project 'monkey' - Issue Type 'Sub-task'");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Current Status", "Mega Open");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Current Status", "Super Open");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("All field values will be retained");
        this.navigation.clickOnNext();
        this.tester.assertTextPresent("Confirmation");
        this.navigation.clickOnNext();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.assertTextPresent("MKY-1");
        this.tester.clickLinkWithText("MKY-1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Open", new String[0]);
        this.tester.clickLinkWithText("Super Sub Task Issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "Sub-task");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Open", new String[0]);
        this.tester.assertTextPresent("monkey");
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    public void testBulkMoveIssueWithoutVersionPermission() {
        this.administration.restoreData("TestMoveIssueWithoutVersionPermission.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("New Version 1");
        this.tester.assertTextPresent("New Version 4");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("monkey", "10000_1_pid");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Fix Version/s", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("MKY-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextNotPresent("New Version 1");
        this.tester.assertTextNotPresent("New Version 4");
    }
}

