/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.applinks;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.WebResponse;
import java.util.ArrayList;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.APP_LINKS})
@LoginAs(user="admin")
public class TestAppLinksHostApplication
extends BaseJiraFuncTest {
    private static final String PROJECT_ENTITY_TYPE_NAME = "com.atlassian.applinks.api.application.jira.JiraProjectEntityType";
    private static final Logger log = LoggerFactory.getLogger(TestAppLinksHostApplication.class);
    @Inject
    private FuncTestRestClient restClient;
    @Inject
    private Administration administration;

    @Test
    public void testDocumentationBaseUrlShouldPointToAppLinksDocs() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse docBaseUrl = this.restClient.GET("rest/func-test/1.0/applinks/getDocumentationBaseUrl");
        Assert.assertThat((Object)docBaseUrl.getText(), (Matcher)CoreMatchers.equalTo((Object)"http://confluence.atlassian.com/display/APPLINKS"));
    }

    @Test
    public void testApplicationNameShouldReturnJiraName() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse name = this.restClient.GET("rest/func-test/1.0/applinks/getName");
        Assert.assertThat((Object)name.getText(), (Matcher)CoreMatchers.equalTo((Object)"jWebTest JIRA installation"));
    }

    @Test
    public void testApplicationTypeShouldReturnJira() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse name = this.restClient.GET("rest/func-test/1.0/applinks/getType");
        JSONObject type = new JSONObject(name.getText());
        Assert.assertThat((Object)type.getString("i18nKey"), (Matcher)CoreMatchers.equalTo((Object)"applinks.jira"));
    }

    @Test
    public void testLocalEntitiesShouldReturnAllProjects() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse response = this.restClient.GET("rest/func-test/1.0/applinks/getLocalEntities");
        JSONArray entities = new JSONObject(response.getText()).getJSONArray("entities");
        Assert.assertThat((Object)entities.length(), (Matcher)CoreMatchers.equalTo((Object)2));
        ArrayList<String> projectKeys = new ArrayList<String>();
        for (int i = 0; i < entities.length(); ++i) {
            JSONObject project = entities.getJSONObject(i);
            projectKeys.add(project.getString("key"));
        }
        Assert.assertThat(projectKeys, (Matcher)Matchers.hasItems((Object[])new String[]{"HSP", "MKY"}));
    }

    @Test
    public void testHasPublicSignup() throws Exception {
        if (!this.isBackdoorAvailable()) {
            return;
        }
        WebResponse response = this.restClient.GET("rest/func-test/1.0/applinks/hasPublicSignup");
        Assert.assertThat((Object)response.getText(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
    }

    protected final boolean isBackdoorAvailable() {
        boolean available = this.administration.plugins().isPluginInstalled("com.atlassian.jira.dev.func-test-plugin");
        if (!available) {
            log.info(String.format("Plugin '%s' is not installed", "com.atlassian.jira.dev.func-test-plugin"));
        }
        return available;
    }
}

