/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.gadget;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class PickerClient
extends RestApiClient<PickerClient> {
    public PickerClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
    }

    public List<FilterPickerBean> getMatchedFilters(String query) {
        WebTarget webTarget = this.createResourceGadget().path("pickers").path("filters").queryParam("query", new Object[]{query});
        return ((FilterPickerWrapper)webTarget.request().get(FilterPickerWrapper.class)).filters;
    }

    public List<String> getMatchedFiltersNames(String query) {
        return this.getMatchedFilters(query).stream().map(bean -> bean.name).collect(Collectors.toList());
    }

    @JsonSerialize
    public static class FilterPickerBean {
        public String id;
        public String name;
        public String nameHtml;
        public String descHtml;

        private FilterPickerBean() {
        }

        public FilterPickerBean(String id, String name, String nameHtml, String descHtml) {
            this.id = id;
            this.name = name;
            this.nameHtml = nameHtml;
            this.descHtml = descHtml;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterPickerBean that = (FilterPickerBean)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.nameHtml != null ? !this.nameHtml.equals(that.nameHtml) : that.nameHtml != null) {
                return false;
            }
            return this.descHtml != null ? this.descHtml.equals(that.descHtml) : that.descHtml == null;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.nameHtml != null ? this.nameHtml.hashCode() : 0);
            result = 31 * result + (this.descHtml != null ? this.descHtml.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FilterPickerBean{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", nameHtml='" + this.nameHtml + '\'' + ", descHtml='" + this.descHtml + '\'' + '}';
        }
    }

    @XmlRootElement
    private static class FilterPickerWrapper {
        @XmlElement
        private List<FilterPickerBean> filters;

        public FilterPickerWrapper() {
        }

        public FilterPickerWrapper(List<FilterPickerBean> filters) {
            this.filters = filters;
        }
    }
}

