/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.gadget;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.GadgetSpecClient;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.GADGETS})
public class TestRoadMapGadget
extends BaseJiraFuncTest {
    private static final String PLUGIN_KEY = "com.atlassian.jira.gadgets";
    private static final String MODULE_KEY = "road-map-gadget";
    private static final String LOCATION = "/gadgets/roadmap-gadget.xml";
    private static final String DEFAULT_LOC = "com.atlassian.jira.gadgets:road-map-gadget/gadgets/roadmap-gadget.xml";
    private GadgetSpecClient gadgetSpecClient;

    @Before
    public void setUpClient() {
        this.gadgetSpecClient = new GadgetSpecClient(this.getEnvironmentData());
    }

    @Test
    @LoginAs(user="admin")
    public void testRequestToRoadMapGadgetSpecReturnsSuccess() {
        MatcherAssert.assertThat((Object)this.gadgetSpecClient.getGadgetSpecXML((String)DEFAULT_LOC).statusCode, (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    public void testRequestToRoadMapGadgetSpecReturnsSuccessAnonymously() {
        MatcherAssert.assertThat((Object)this.gadgetSpecClient.getGadgetSpecXML((String)DEFAULT_LOC).statusCode, (Matcher)Matchers.equalTo((Object)200));
    }

    @Test
    @LoginAs(user="admin")
    public void testRoadMapGadgetIsAddable() {
        List<String> addableGadgets = this.gadgetSpecClient.getAddableGadgets();
        MatcherAssert.assertThat(addableGadgets, (Matcher)Matchers.hasItem((Object)DEFAULT_LOC));
    }

    @Test
    @LoginAs(user="admin")
    public void testRoadMapGadgetIsAvailableInFeed() {
        String feedResourceContent = this.gadgetSpecClient.getFeedResourceContent();
        MatcherAssert.assertThat((Object)feedResourceContent, (Matcher)Matchers.containsString((String)DEFAULT_LOC));
    }
}

