/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestClusterUpgradeStateResource
extends BaseJiraRestTest {
    private static final String CLUSTER_UPGRADE_STATE_DARK_FEATURE = "jira.zdu.cluster-upgrade-state";
    @Inject
    private FuncTestRestClient restClient;

    @Test
    public void clusterStateResourceIsAvailableWithDarkFeature() throws Exception {
        this.enableDarkFeature();
        WebResponse response = this.getClusterState();
        MatcherAssert.assertThat((Object)response.getResponseCode(), (Matcher)CoreMatchers.is((Object)200));
    }

    private WebResponse getClusterState() throws Exception {
        return this.restClient.GET("/rest/api/2/cluster/zdu/state");
    }

    private void enableDarkFeature() {
        this.backdoor.darkFeatures().enableForSite(CLUSTER_UPGRADE_STATE_DARK_FEATURE);
    }
}

