/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.CurrentUserPreferencesClient;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCurrentUserPreferencesResource
extends BaseJiraFuncTest {
    private static final String SOME_KEY = "someKey";
    private static final String SOME_VALUE = "someValue";
    private CurrentUserPreferencesClient preferencesClient;

    @Before
    public void setUpTest() {
        this.preferencesClient = new CurrentUserPreferencesClient((JIRAEnvironmentData)this.getEnvironmentData());
    }

    @After
    public void tearDownTest() {
        this.preferencesClient.close();
    }

    @Test
    public void testHappyPathUseCase() {
        Response responseGet1 = this.preferencesClient.getPreference(SOME_KEY);
        Assert.assertThat((Object)responseGet1.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        Response responsePut = this.preferencesClient.setPreference(SOME_KEY, SOME_VALUE);
        Assert.assertNotNull((Object)responsePut);
        Assert.assertThat((Object)responsePut.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        Response responseGet2 = this.preferencesClient.getPreference(SOME_KEY);
        Assert.assertThat((Object)responseGet2.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        String message = (String)responseGet2.readEntity(String.class);
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.equalTo((Object)SOME_VALUE));
        Response responseDelete1 = this.preferencesClient.removePreference(SOME_KEY);
        Assert.assertThat((Object)responseDelete1.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        Response responseGet3 = this.preferencesClient.getPreference(SOME_KEY);
        Assert.assertThat((Object)responseGet3.getStatus(), (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }
}

